package zio.aws.firehose.model
import scala.jdk.CollectionConverters.*
sealed trait DeliveryStreamType {
  def unwrap: software.amazon.awssdk.services.firehose.model.DeliveryStreamType
}
object DeliveryStreamType {
  def wrap(
      value: software.amazon.awssdk.services.firehose.model.DeliveryStreamType
  ): zio.aws.firehose.model.DeliveryStreamType = value match {
    case software.amazon.awssdk.services.firehose.model.DeliveryStreamType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.firehose.model.DeliveryStreamType.DIRECT_PUT =>
      val r = DirectPut
      r
    case software.amazon.awssdk.services.firehose.model.DeliveryStreamType.KINESIS_STREAM_AS_SOURCE =>
      val r = KinesisStreamAsSource
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.firehose.model.DeliveryStreamType {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.DeliveryStreamType =
      software.amazon.awssdk.services.firehose.model.DeliveryStreamType.UNKNOWN_TO_SDK_VERSION
  }
  case object DirectPut extends zio.aws.firehose.model.DeliveryStreamType {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.DeliveryStreamType =
      software.amazon.awssdk.services.firehose.model.DeliveryStreamType.DIRECT_PUT
  }
  case object KinesisStreamAsSource
      extends zio.aws.firehose.model.DeliveryStreamType {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.DeliveryStreamType =
      software.amazon.awssdk.services.firehose.model.DeliveryStreamType.KINESIS_STREAM_AS_SOURCE
  }
}
