package zio.aws.firehose.model
import java.lang.Integer
import zio.aws.firehose.model.primitives.{
  DestinationId,
  DescribeDeliveryStreamInputLimit,
  DeliveryStreamName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeDeliveryStreamRequest(
    deliveryStreamName: DeliveryStreamName,
    limit: Option[DescribeDeliveryStreamInputLimit] = None,
    exclusiveStartDestinationId: Option[DestinationId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.DescribeDeliveryStreamRequest = {
    import DescribeDeliveryStreamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.DescribeDeliveryStreamRequest
      .builder()
      .deliveryStreamName(
        DeliveryStreamName.unwrap(deliveryStreamName): java.lang.String
      )
      .optionallyWith(
        limit.map(value =>
          DescribeDeliveryStreamInputLimit.unwrap(value): Integer
        )
      )(_.limit)
      .optionallyWith(
        exclusiveStartDestinationId.map(value =>
          DestinationId.unwrap(value): java.lang.String
        )
      )(_.exclusiveStartDestinationId)
      .build()
  }
  def asReadOnly
      : zio.aws.firehose.model.DescribeDeliveryStreamRequest.ReadOnly =
    zio.aws.firehose.model.DescribeDeliveryStreamRequest.wrap(buildAwsValue())
}
object DescribeDeliveryStreamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.DescribeDeliveryStreamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.DescribeDeliveryStreamRequest =
      zio.aws.firehose.model.DescribeDeliveryStreamRequest(
        deliveryStreamName,
        limit.map(value => value),
        exclusiveStartDestinationId.map(value => value)
      )
    def deliveryStreamName: DeliveryStreamName
    def limit: Option[DescribeDeliveryStreamInputLimit]
    def exclusiveStartDestinationId: Option[DestinationId]
    def getDeliveryStreamName: ZIO[Any, Nothing, DeliveryStreamName] =
      ZIO.succeed(deliveryStreamName)
    def getLimit: ZIO[Any, AwsError, DescribeDeliveryStreamInputLimit] =
      AwsError.unwrapOptionField("limit", limit)
    def getExclusiveStartDestinationId: ZIO[Any, AwsError, DestinationId] =
      AwsError.unwrapOptionField(
        "exclusiveStartDestinationId",
        exclusiveStartDestinationId
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.DescribeDeliveryStreamRequest
  ) extends zio.aws.firehose.model.DescribeDeliveryStreamRequest.ReadOnly {
    override val deliveryStreamName: DeliveryStreamName =
      zio.aws.firehose.model.primitives
        .DeliveryStreamName(impl.deliveryStreamName())
    override val limit: Option[DescribeDeliveryStreamInputLimit] = scala
      .Option(impl.limit())
      .map(value =>
        zio.aws.firehose.model.primitives
          .DescribeDeliveryStreamInputLimit(value)
      )
    override val exclusiveStartDestinationId: Option[DestinationId] = scala
      .Option(impl.exclusiveStartDestinationId())
      .map(value => zio.aws.firehose.model.primitives.DestinationId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.DescribeDeliveryStreamRequest
  ): zio.aws.firehose.model.DescribeDeliveryStreamRequest.ReadOnly =
    new Wrapper(impl)
}
