package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.BooleanObject
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DynamicPartitioningConfiguration(
    retryOptions: Option[zio.aws.firehose.model.RetryOptions] = None,
    enabled: Option[BooleanObject] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.DynamicPartitioningConfiguration = {
    import DynamicPartitioningConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.DynamicPartitioningConfiguration
      .builder()
      .optionallyWith(retryOptions.map(value => value.buildAwsValue()))(
        _.retryOptions
      )
      .optionallyWith(
        enabled.map(value => BooleanObject.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .build()
  }
  def asReadOnly
      : zio.aws.firehose.model.DynamicPartitioningConfiguration.ReadOnly =
    zio.aws.firehose.model.DynamicPartitioningConfiguration
      .wrap(buildAwsValue())
}
object DynamicPartitioningConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.DynamicPartitioningConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.DynamicPartitioningConfiguration =
      zio.aws.firehose.model.DynamicPartitioningConfiguration(
        retryOptions.map(value => value.asEditable),
        enabled.map(value => value)
      )
    def retryOptions: Option[zio.aws.firehose.model.RetryOptions.ReadOnly]
    def enabled: Option[BooleanObject]
    def getRetryOptions
        : ZIO[Any, AwsError, zio.aws.firehose.model.RetryOptions.ReadOnly] =
      AwsError.unwrapOptionField("retryOptions", retryOptions)
    def getEnabled: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.DynamicPartitioningConfiguration
  ) extends zio.aws.firehose.model.DynamicPartitioningConfiguration.ReadOnly {
    override val retryOptions
        : Option[zio.aws.firehose.model.RetryOptions.ReadOnly] = scala
      .Option(impl.retryOptions())
      .map(value => zio.aws.firehose.model.RetryOptions.wrap(value))
    override val enabled: Option[BooleanObject] = scala
      .Option(impl.enabled())
      .map(value => zio.aws.firehose.model.primitives.BooleanObject(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.DynamicPartitioningConfiguration
  ): zio.aws.firehose.model.DynamicPartitioningConfiguration.ReadOnly =
    new Wrapper(impl)
}
