package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.{
  ElasticsearchIndexName,
  ElasticsearchTypeName,
  ElasticsearchDomainARN,
  RoleARN,
  ElasticsearchClusterEndpoint
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ElasticsearchDestinationConfiguration(
    roleARN: RoleARN,
    domainARN: Option[ElasticsearchDomainARN] = None,
    clusterEndpoint: Option[ElasticsearchClusterEndpoint] = None,
    indexName: ElasticsearchIndexName,
    typeName: Option[ElasticsearchTypeName] = None,
    indexRotationPeriod: Option[
      zio.aws.firehose.model.ElasticsearchIndexRotationPeriod
    ] = None,
    bufferingHints: Option[zio.aws.firehose.model.ElasticsearchBufferingHints] =
      None,
    retryOptions: Option[zio.aws.firehose.model.ElasticsearchRetryOptions] =
      None,
    s3BackupMode: Option[zio.aws.firehose.model.ElasticsearchS3BackupMode] =
      None,
    s3Configuration: zio.aws.firehose.model.S3DestinationConfiguration,
    processingConfiguration: Option[
      zio.aws.firehose.model.ProcessingConfiguration
    ] = None,
    cloudWatchLoggingOptions: Option[
      zio.aws.firehose.model.CloudWatchLoggingOptions
    ] = None,
    vpcConfiguration: Option[zio.aws.firehose.model.VpcConfiguration] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.ElasticsearchDestinationConfiguration = {
    import ElasticsearchDestinationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.ElasticsearchDestinationConfiguration
      .builder()
      .roleARN(RoleARN.unwrap(roleARN): java.lang.String)
      .optionallyWith(
        domainARN.map(value =>
          ElasticsearchDomainARN.unwrap(value): java.lang.String
        )
      )(_.domainARN)
      .optionallyWith(
        clusterEndpoint.map(value =>
          ElasticsearchClusterEndpoint.unwrap(value): java.lang.String
        )
      )(_.clusterEndpoint)
      .indexName(ElasticsearchIndexName.unwrap(indexName): java.lang.String)
      .optionallyWith(
        typeName.map(value =>
          ElasticsearchTypeName.unwrap(value): java.lang.String
        )
      )(_.typeName)
      .optionallyWith(indexRotationPeriod.map(value => value.unwrap))(
        _.indexRotationPeriod
      )
      .optionallyWith(bufferingHints.map(value => value.buildAwsValue()))(
        _.bufferingHints
      )
      .optionallyWith(retryOptions.map(value => value.buildAwsValue()))(
        _.retryOptions
      )
      .optionallyWith(s3BackupMode.map(value => value.unwrap))(_.s3BackupMode)
      .s3Configuration(s3Configuration.buildAwsValue())
      .optionallyWith(
        processingConfiguration.map(value => value.buildAwsValue())
      )(_.processingConfiguration)
      .optionallyWith(
        cloudWatchLoggingOptions.map(value => value.buildAwsValue())
      )(_.cloudWatchLoggingOptions)
      .optionallyWith(vpcConfiguration.map(value => value.buildAwsValue()))(
        _.vpcConfiguration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.firehose.model.ElasticsearchDestinationConfiguration.ReadOnly =
    zio.aws.firehose.model.ElasticsearchDestinationConfiguration
      .wrap(buildAwsValue())
}
object ElasticsearchDestinationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.ElasticsearchDestinationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.firehose.model.ElasticsearchDestinationConfiguration =
      zio.aws.firehose.model.ElasticsearchDestinationConfiguration(
        roleARN,
        domainARN.map(value => value),
        clusterEndpoint.map(value => value),
        indexName,
        typeName.map(value => value),
        indexRotationPeriod.map(value => value),
        bufferingHints.map(value => value.asEditable),
        retryOptions.map(value => value.asEditable),
        s3BackupMode.map(value => value),
        s3Configuration.asEditable,
        processingConfiguration.map(value => value.asEditable),
        cloudWatchLoggingOptions.map(value => value.asEditable),
        vpcConfiguration.map(value => value.asEditable)
      )
    def roleARN: RoleARN
    def domainARN: Option[ElasticsearchDomainARN]
    def clusterEndpoint: Option[ElasticsearchClusterEndpoint]
    def indexName: ElasticsearchIndexName
    def typeName: Option[ElasticsearchTypeName]
    def indexRotationPeriod
        : Option[zio.aws.firehose.model.ElasticsearchIndexRotationPeriod]
    def bufferingHints
        : Option[zio.aws.firehose.model.ElasticsearchBufferingHints.ReadOnly]
    def retryOptions
        : Option[zio.aws.firehose.model.ElasticsearchRetryOptions.ReadOnly]
    def s3BackupMode: Option[zio.aws.firehose.model.ElasticsearchS3BackupMode]
    def s3Configuration
        : zio.aws.firehose.model.S3DestinationConfiguration.ReadOnly
    def processingConfiguration
        : Option[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly]
    def cloudWatchLoggingOptions
        : Option[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly]
    def vpcConfiguration
        : Option[zio.aws.firehose.model.VpcConfiguration.ReadOnly]
    def getRoleARN: ZIO[Any, Nothing, RoleARN] = ZIO.succeed(roleARN)
    def getDomainARN: ZIO[Any, AwsError, ElasticsearchDomainARN] =
      AwsError.unwrapOptionField("domainARN", domainARN)
    def getClusterEndpoint: ZIO[Any, AwsError, ElasticsearchClusterEndpoint] =
      AwsError.unwrapOptionField("clusterEndpoint", clusterEndpoint)
    def getIndexName: ZIO[Any, Nothing, ElasticsearchIndexName] =
      ZIO.succeed(indexName)
    def getTypeName: ZIO[Any, AwsError, ElasticsearchTypeName] =
      AwsError.unwrapOptionField("typeName", typeName)
    def getIndexRotationPeriod: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.ElasticsearchIndexRotationPeriod
    ] = AwsError.unwrapOptionField("indexRotationPeriod", indexRotationPeriod)
    def getBufferingHints: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.ElasticsearchBufferingHints.ReadOnly
    ] = AwsError.unwrapOptionField("bufferingHints", bufferingHints)
    def getRetryOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.ElasticsearchRetryOptions.ReadOnly
    ] = AwsError.unwrapOptionField("retryOptions", retryOptions)
    def getS3BackupMode
        : ZIO[Any, AwsError, zio.aws.firehose.model.ElasticsearchS3BackupMode] =
      AwsError.unwrapOptionField("s3BackupMode", s3BackupMode)
    def getS3Configuration: ZIO[
      Any,
      Nothing,
      zio.aws.firehose.model.S3DestinationConfiguration.ReadOnly
    ] = ZIO.succeed(s3Configuration)
    def getProcessingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.ProcessingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "processingConfiguration",
      processingConfiguration
    )
    def getCloudWatchLoggingOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudWatchLoggingOptions",
      cloudWatchLoggingOptions
    )
    def getVpcConfiguration
        : ZIO[Any, AwsError, zio.aws.firehose.model.VpcConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfiguration", vpcConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.ElasticsearchDestinationConfiguration
  ) extends zio.aws.firehose.model.ElasticsearchDestinationConfiguration.ReadOnly {
    override val roleARN: RoleARN =
      zio.aws.firehose.model.primitives.RoleARN(impl.roleARN())
    override val domainARN: Option[ElasticsearchDomainARN] = scala
      .Option(impl.domainARN())
      .map(value =>
        zio.aws.firehose.model.primitives.ElasticsearchDomainARN(value)
      )
    override val clusterEndpoint: Option[ElasticsearchClusterEndpoint] = scala
      .Option(impl.clusterEndpoint())
      .map(value =>
        zio.aws.firehose.model.primitives.ElasticsearchClusterEndpoint(value)
      )
    override val indexName: ElasticsearchIndexName =
      zio.aws.firehose.model.primitives.ElasticsearchIndexName(impl.indexName())
    override val typeName: Option[ElasticsearchTypeName] = scala
      .Option(impl.typeName())
      .map(value =>
        zio.aws.firehose.model.primitives.ElasticsearchTypeName(value)
      )
    override val indexRotationPeriod
        : Option[zio.aws.firehose.model.ElasticsearchIndexRotationPeriod] =
      scala
        .Option(impl.indexRotationPeriod())
        .map(value =>
          zio.aws.firehose.model.ElasticsearchIndexRotationPeriod.wrap(value)
        )
    override val bufferingHints
        : Option[zio.aws.firehose.model.ElasticsearchBufferingHints.ReadOnly] =
      scala
        .Option(impl.bufferingHints())
        .map(value =>
          zio.aws.firehose.model.ElasticsearchBufferingHints.wrap(value)
        )
    override val retryOptions
        : Option[zio.aws.firehose.model.ElasticsearchRetryOptions.ReadOnly] =
      scala
        .Option(impl.retryOptions())
        .map(value =>
          zio.aws.firehose.model.ElasticsearchRetryOptions.wrap(value)
        )
    override val s3BackupMode
        : Option[zio.aws.firehose.model.ElasticsearchS3BackupMode] = scala
      .Option(impl.s3BackupMode())
      .map(value =>
        zio.aws.firehose.model.ElasticsearchS3BackupMode.wrap(value)
      )
    override val s3Configuration
        : zio.aws.firehose.model.S3DestinationConfiguration.ReadOnly =
      zio.aws.firehose.model.S3DestinationConfiguration
        .wrap(impl.s3Configuration())
    override val processingConfiguration
        : Option[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly] =
      scala
        .Option(impl.processingConfiguration())
        .map(value =>
          zio.aws.firehose.model.ProcessingConfiguration.wrap(value)
        )
    override val cloudWatchLoggingOptions
        : Option[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly] =
      scala
        .Option(impl.cloudWatchLoggingOptions())
        .map(value =>
          zio.aws.firehose.model.CloudWatchLoggingOptions.wrap(value)
        )
    override val vpcConfiguration
        : Option[zio.aws.firehose.model.VpcConfiguration.ReadOnly] = scala
      .Option(impl.vpcConfiguration())
      .map(value => zio.aws.firehose.model.VpcConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.ElasticsearchDestinationConfiguration
  ): zio.aws.firehose.model.ElasticsearchDestinationConfiguration.ReadOnly =
    new Wrapper(impl)
}
