package zio.aws.firehose.model
import java.lang.Integer
import zio.aws.firehose.model.primitives.ElasticsearchRetryDurationInSeconds
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ElasticsearchRetryOptions(
    durationInSeconds: Option[ElasticsearchRetryDurationInSeconds] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.ElasticsearchRetryOptions = {
    import ElasticsearchRetryOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.ElasticsearchRetryOptions
      .builder()
      .optionallyWith(
        durationInSeconds.map(value =>
          ElasticsearchRetryDurationInSeconds.unwrap(value): Integer
        )
      )(_.durationInSeconds)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.ElasticsearchRetryOptions.ReadOnly =
    zio.aws.firehose.model.ElasticsearchRetryOptions.wrap(buildAwsValue())
}
object ElasticsearchRetryOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.ElasticsearchRetryOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.ElasticsearchRetryOptions =
      zio.aws.firehose.model
        .ElasticsearchRetryOptions(durationInSeconds.map(value => value))
    def durationInSeconds: Option[ElasticsearchRetryDurationInSeconds]
    def getDurationInSeconds
        : ZIO[Any, AwsError, ElasticsearchRetryDurationInSeconds] =
      AwsError.unwrapOptionField("durationInSeconds", durationInSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.ElasticsearchRetryOptions
  ) extends zio.aws.firehose.model.ElasticsearchRetryOptions.ReadOnly {
    override val durationInSeconds
        : Option[ElasticsearchRetryDurationInSeconds] = scala
      .Option(impl.durationInSeconds())
      .map(value =>
        zio.aws.firehose.model.primitives
          .ElasticsearchRetryDurationInSeconds(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.ElasticsearchRetryOptions
  ): zio.aws.firehose.model.ElasticsearchRetryOptions.ReadOnly = new Wrapper(
    impl
  )
}
