package zio.aws.firehose.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class EncryptionConfiguration(
    noEncryptionConfig: Option[zio.aws.firehose.model.NoEncryptionConfig] =
      None,
    kmsEncryptionConfig: Option[zio.aws.firehose.model.KMSEncryptionConfig] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.EncryptionConfiguration = {
    import EncryptionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.EncryptionConfiguration
      .builder()
      .optionallyWith(noEncryptionConfig.map(value => value.unwrap))(
        _.noEncryptionConfig
      )
      .optionallyWith(kmsEncryptionConfig.map(value => value.buildAwsValue()))(
        _.kmsEncryptionConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.EncryptionConfiguration.ReadOnly =
    zio.aws.firehose.model.EncryptionConfiguration.wrap(buildAwsValue())
}
object EncryptionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.EncryptionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.EncryptionConfiguration =
      zio.aws.firehose.model.EncryptionConfiguration(
        noEncryptionConfig.map(value => value),
        kmsEncryptionConfig.map(value => value.asEditable)
      )
    def noEncryptionConfig: Option[zio.aws.firehose.model.NoEncryptionConfig]
    def kmsEncryptionConfig
        : Option[zio.aws.firehose.model.KMSEncryptionConfig.ReadOnly]
    def getNoEncryptionConfig
        : ZIO[Any, AwsError, zio.aws.firehose.model.NoEncryptionConfig] =
      AwsError.unwrapOptionField("noEncryptionConfig", noEncryptionConfig)
    def getKmsEncryptionConfig: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.KMSEncryptionConfig.ReadOnly
    ] = AwsError.unwrapOptionField("kmsEncryptionConfig", kmsEncryptionConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.EncryptionConfiguration
  ) extends zio.aws.firehose.model.EncryptionConfiguration.ReadOnly {
    override val noEncryptionConfig
        : Option[zio.aws.firehose.model.NoEncryptionConfig] = scala
      .Option(impl.noEncryptionConfig())
      .map(value => zio.aws.firehose.model.NoEncryptionConfig.wrap(value))
    override val kmsEncryptionConfig
        : Option[zio.aws.firehose.model.KMSEncryptionConfig.ReadOnly] = scala
      .Option(impl.kmsEncryptionConfig())
      .map(value => zio.aws.firehose.model.KMSEncryptionConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.EncryptionConfiguration
  ): zio.aws.firehose.model.EncryptionConfiguration.ReadOnly = new Wrapper(impl)
}
