package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.{
  ErrorOutputPrefix,
  Prefix,
  BucketARN,
  RoleARN
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ExtendedS3DestinationDescription(
    roleARN: RoleARN,
    bucketARN: BucketARN,
    prefix: Option[Prefix] = None,
    errorOutputPrefix: Option[ErrorOutputPrefix] = None,
    bufferingHints: zio.aws.firehose.model.BufferingHints,
    compressionFormat: zio.aws.firehose.model.CompressionFormat,
    encryptionConfiguration: zio.aws.firehose.model.EncryptionConfiguration,
    cloudWatchLoggingOptions: Option[
      zio.aws.firehose.model.CloudWatchLoggingOptions
    ] = None,
    processingConfiguration: Option[
      zio.aws.firehose.model.ProcessingConfiguration
    ] = None,
    s3BackupMode: Option[zio.aws.firehose.model.S3BackupMode] = None,
    s3BackupDescription: Option[
      zio.aws.firehose.model.S3DestinationDescription
    ] = None,
    dataFormatConversionConfiguration: Option[
      zio.aws.firehose.model.DataFormatConversionConfiguration
    ] = None,
    dynamicPartitioningConfiguration: Option[
      zio.aws.firehose.model.DynamicPartitioningConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.ExtendedS3DestinationDescription = {
    import ExtendedS3DestinationDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.ExtendedS3DestinationDescription
      .builder()
      .roleARN(RoleARN.unwrap(roleARN): java.lang.String)
      .bucketARN(BucketARN.unwrap(bucketARN): java.lang.String)
      .optionallyWith(
        prefix.map(value => Prefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(
        errorOutputPrefix.map(value =>
          ErrorOutputPrefix.unwrap(value): java.lang.String
        )
      )(_.errorOutputPrefix)
      .bufferingHints(bufferingHints.buildAwsValue())
      .compressionFormat(compressionFormat.unwrap)
      .encryptionConfiguration(encryptionConfiguration.buildAwsValue())
      .optionallyWith(
        cloudWatchLoggingOptions.map(value => value.buildAwsValue())
      )(_.cloudWatchLoggingOptions)
      .optionallyWith(
        processingConfiguration.map(value => value.buildAwsValue())
      )(_.processingConfiguration)
      .optionallyWith(s3BackupMode.map(value => value.unwrap))(_.s3BackupMode)
      .optionallyWith(s3BackupDescription.map(value => value.buildAwsValue()))(
        _.s3BackupDescription
      )
      .optionallyWith(
        dataFormatConversionConfiguration.map(value => value.buildAwsValue())
      )(_.dataFormatConversionConfiguration)
      .optionallyWith(
        dynamicPartitioningConfiguration.map(value => value.buildAwsValue())
      )(_.dynamicPartitioningConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.firehose.model.ExtendedS3DestinationDescription.ReadOnly =
    zio.aws.firehose.model.ExtendedS3DestinationDescription
      .wrap(buildAwsValue())
}
object ExtendedS3DestinationDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.ExtendedS3DestinationDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.ExtendedS3DestinationDescription =
      zio.aws.firehose.model.ExtendedS3DestinationDescription(
        roleARN,
        bucketARN,
        prefix.map(value => value),
        errorOutputPrefix.map(value => value),
        bufferingHints.asEditable,
        compressionFormat,
        encryptionConfiguration.asEditable,
        cloudWatchLoggingOptions.map(value => value.asEditable),
        processingConfiguration.map(value => value.asEditable),
        s3BackupMode.map(value => value),
        s3BackupDescription.map(value => value.asEditable),
        dataFormatConversionConfiguration.map(value => value.asEditable),
        dynamicPartitioningConfiguration.map(value => value.asEditable)
      )
    def roleARN: RoleARN
    def bucketARN: BucketARN
    def prefix: Option[Prefix]
    def errorOutputPrefix: Option[ErrorOutputPrefix]
    def bufferingHints: zio.aws.firehose.model.BufferingHints.ReadOnly
    def compressionFormat: zio.aws.firehose.model.CompressionFormat
    def encryptionConfiguration
        : zio.aws.firehose.model.EncryptionConfiguration.ReadOnly
    def cloudWatchLoggingOptions
        : Option[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly]
    def processingConfiguration
        : Option[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly]
    def s3BackupMode: Option[zio.aws.firehose.model.S3BackupMode]
    def s3BackupDescription
        : Option[zio.aws.firehose.model.S3DestinationDescription.ReadOnly]
    def dataFormatConversionConfiguration: Option[
      zio.aws.firehose.model.DataFormatConversionConfiguration.ReadOnly
    ]
    def dynamicPartitioningConfiguration: Option[
      zio.aws.firehose.model.DynamicPartitioningConfiguration.ReadOnly
    ]
    def getRoleARN: ZIO[Any, Nothing, RoleARN] = ZIO.succeed(roleARN)
    def getBucketARN: ZIO[Any, Nothing, BucketARN] = ZIO.succeed(bucketARN)
    def getPrefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getErrorOutputPrefix: ZIO[Any, AwsError, ErrorOutputPrefix] =
      AwsError.unwrapOptionField("errorOutputPrefix", errorOutputPrefix)
    def getBufferingHints
        : ZIO[Any, Nothing, zio.aws.firehose.model.BufferingHints.ReadOnly] =
      ZIO.succeed(bufferingHints)
    def getCompressionFormat
        : ZIO[Any, Nothing, zio.aws.firehose.model.CompressionFormat] =
      ZIO.succeed(compressionFormat)
    def getEncryptionConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.firehose.model.EncryptionConfiguration.ReadOnly
    ] = ZIO.succeed(encryptionConfiguration)
    def getCloudWatchLoggingOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudWatchLoggingOptions",
      cloudWatchLoggingOptions
    )
    def getProcessingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.ProcessingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "processingConfiguration",
      processingConfiguration
    )
    def getS3BackupMode
        : ZIO[Any, AwsError, zio.aws.firehose.model.S3BackupMode] =
      AwsError.unwrapOptionField("s3BackupMode", s3BackupMode)
    def getS3BackupDescription: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.S3DestinationDescription.ReadOnly
    ] = AwsError.unwrapOptionField("s3BackupDescription", s3BackupDescription)
    def getDataFormatConversionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.DataFormatConversionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dataFormatConversionConfiguration",
      dataFormatConversionConfiguration
    )
    def getDynamicPartitioningConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.DynamicPartitioningConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dynamicPartitioningConfiguration",
      dynamicPartitioningConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.ExtendedS3DestinationDescription
  ) extends zio.aws.firehose.model.ExtendedS3DestinationDescription.ReadOnly {
    override val roleARN: RoleARN =
      zio.aws.firehose.model.primitives.RoleARN(impl.roleARN())
    override val bucketARN: BucketARN =
      zio.aws.firehose.model.primitives.BucketARN(impl.bucketARN())
    override val prefix: Option[Prefix] = scala
      .Option(impl.prefix())
      .map(value => zio.aws.firehose.model.primitives.Prefix(value))
    override val errorOutputPrefix: Option[ErrorOutputPrefix] = scala
      .Option(impl.errorOutputPrefix())
      .map(value => zio.aws.firehose.model.primitives.ErrorOutputPrefix(value))
    override val bufferingHints
        : zio.aws.firehose.model.BufferingHints.ReadOnly =
      zio.aws.firehose.model.BufferingHints.wrap(impl.bufferingHints())
    override val compressionFormat: zio.aws.firehose.model.CompressionFormat =
      zio.aws.firehose.model.CompressionFormat.wrap(impl.compressionFormat())
    override val encryptionConfiguration
        : zio.aws.firehose.model.EncryptionConfiguration.ReadOnly =
      zio.aws.firehose.model.EncryptionConfiguration
        .wrap(impl.encryptionConfiguration())
    override val cloudWatchLoggingOptions
        : Option[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly] =
      scala
        .Option(impl.cloudWatchLoggingOptions())
        .map(value =>
          zio.aws.firehose.model.CloudWatchLoggingOptions.wrap(value)
        )
    override val processingConfiguration
        : Option[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly] =
      scala
        .Option(impl.processingConfiguration())
        .map(value =>
          zio.aws.firehose.model.ProcessingConfiguration.wrap(value)
        )
    override val s3BackupMode: Option[zio.aws.firehose.model.S3BackupMode] =
      scala
        .Option(impl.s3BackupMode())
        .map(value => zio.aws.firehose.model.S3BackupMode.wrap(value))
    override val s3BackupDescription
        : Option[zio.aws.firehose.model.S3DestinationDescription.ReadOnly] =
      scala
        .Option(impl.s3BackupDescription())
        .map(value =>
          zio.aws.firehose.model.S3DestinationDescription.wrap(value)
        )
    override val dataFormatConversionConfiguration: Option[
      zio.aws.firehose.model.DataFormatConversionConfiguration.ReadOnly
    ] = scala
      .Option(impl.dataFormatConversionConfiguration())
      .map(value =>
        zio.aws.firehose.model.DataFormatConversionConfiguration.wrap(value)
      )
    override val dynamicPartitioningConfiguration: Option[
      zio.aws.firehose.model.DynamicPartitioningConfiguration.ReadOnly
    ] = scala
      .Option(impl.dynamicPartitioningConfiguration())
      .map(value =>
        zio.aws.firehose.model.DynamicPartitioningConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.ExtendedS3DestinationDescription
  ): zio.aws.firehose.model.ExtendedS3DestinationDescription.ReadOnly =
    new Wrapper(impl)
}
