package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.{
  ErrorOutputPrefix,
  Prefix,
  BucketARN,
  RoleARN
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ExtendedS3DestinationUpdate(
    roleARN: Option[RoleARN] = None,
    bucketARN: Option[BucketARN] = None,
    prefix: Option[Prefix] = None,
    errorOutputPrefix: Option[ErrorOutputPrefix] = None,
    bufferingHints: Option[zio.aws.firehose.model.BufferingHints] = None,
    compressionFormat: Option[zio.aws.firehose.model.CompressionFormat] = None,
    encryptionConfiguration: Option[
      zio.aws.firehose.model.EncryptionConfiguration
    ] = None,
    cloudWatchLoggingOptions: Option[
      zio.aws.firehose.model.CloudWatchLoggingOptions
    ] = None,
    processingConfiguration: Option[
      zio.aws.firehose.model.ProcessingConfiguration
    ] = None,
    s3BackupMode: Option[zio.aws.firehose.model.S3BackupMode] = None,
    s3BackupUpdate: Option[zio.aws.firehose.model.S3DestinationUpdate] = None,
    dataFormatConversionConfiguration: Option[
      zio.aws.firehose.model.DataFormatConversionConfiguration
    ] = None,
    dynamicPartitioningConfiguration: Option[
      zio.aws.firehose.model.DynamicPartitioningConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.ExtendedS3DestinationUpdate = {
    import ExtendedS3DestinationUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.ExtendedS3DestinationUpdate
      .builder()
      .optionallyWith(
        roleARN.map(value => RoleARN.unwrap(value): java.lang.String)
      )(_.roleARN)
      .optionallyWith(
        bucketARN.map(value => BucketARN.unwrap(value): java.lang.String)
      )(_.bucketARN)
      .optionallyWith(
        prefix.map(value => Prefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(
        errorOutputPrefix.map(value =>
          ErrorOutputPrefix.unwrap(value): java.lang.String
        )
      )(_.errorOutputPrefix)
      .optionallyWith(bufferingHints.map(value => value.buildAwsValue()))(
        _.bufferingHints
      )
      .optionallyWith(compressionFormat.map(value => value.unwrap))(
        _.compressionFormat
      )
      .optionallyWith(
        encryptionConfiguration.map(value => value.buildAwsValue())
      )(_.encryptionConfiguration)
      .optionallyWith(
        cloudWatchLoggingOptions.map(value => value.buildAwsValue())
      )(_.cloudWatchLoggingOptions)
      .optionallyWith(
        processingConfiguration.map(value => value.buildAwsValue())
      )(_.processingConfiguration)
      .optionallyWith(s3BackupMode.map(value => value.unwrap))(_.s3BackupMode)
      .optionallyWith(s3BackupUpdate.map(value => value.buildAwsValue()))(
        _.s3BackupUpdate
      )
      .optionallyWith(
        dataFormatConversionConfiguration.map(value => value.buildAwsValue())
      )(_.dataFormatConversionConfiguration)
      .optionallyWith(
        dynamicPartitioningConfiguration.map(value => value.buildAwsValue())
      )(_.dynamicPartitioningConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.ExtendedS3DestinationUpdate.ReadOnly =
    zio.aws.firehose.model.ExtendedS3DestinationUpdate.wrap(buildAwsValue())
}
object ExtendedS3DestinationUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.ExtendedS3DestinationUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.ExtendedS3DestinationUpdate =
      zio.aws.firehose.model.ExtendedS3DestinationUpdate(
        roleARN.map(value => value),
        bucketARN.map(value => value),
        prefix.map(value => value),
        errorOutputPrefix.map(value => value),
        bufferingHints.map(value => value.asEditable),
        compressionFormat.map(value => value),
        encryptionConfiguration.map(value => value.asEditable),
        cloudWatchLoggingOptions.map(value => value.asEditable),
        processingConfiguration.map(value => value.asEditable),
        s3BackupMode.map(value => value),
        s3BackupUpdate.map(value => value.asEditable),
        dataFormatConversionConfiguration.map(value => value.asEditable),
        dynamicPartitioningConfiguration.map(value => value.asEditable)
      )
    def roleARN: Option[RoleARN]
    def bucketARN: Option[BucketARN]
    def prefix: Option[Prefix]
    def errorOutputPrefix: Option[ErrorOutputPrefix]
    def bufferingHints: Option[zio.aws.firehose.model.BufferingHints.ReadOnly]
    def compressionFormat: Option[zio.aws.firehose.model.CompressionFormat]
    def encryptionConfiguration
        : Option[zio.aws.firehose.model.EncryptionConfiguration.ReadOnly]
    def cloudWatchLoggingOptions
        : Option[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly]
    def processingConfiguration
        : Option[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly]
    def s3BackupMode: Option[zio.aws.firehose.model.S3BackupMode]
    def s3BackupUpdate
        : Option[zio.aws.firehose.model.S3DestinationUpdate.ReadOnly]
    def dataFormatConversionConfiguration: Option[
      zio.aws.firehose.model.DataFormatConversionConfiguration.ReadOnly
    ]
    def dynamicPartitioningConfiguration: Option[
      zio.aws.firehose.model.DynamicPartitioningConfiguration.ReadOnly
    ]
    def getRoleARN: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("roleARN", roleARN)
    def getBucketARN: ZIO[Any, AwsError, BucketARN] =
      AwsError.unwrapOptionField("bucketARN", bucketARN)
    def getPrefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getErrorOutputPrefix: ZIO[Any, AwsError, ErrorOutputPrefix] =
      AwsError.unwrapOptionField("errorOutputPrefix", errorOutputPrefix)
    def getBufferingHints
        : ZIO[Any, AwsError, zio.aws.firehose.model.BufferingHints.ReadOnly] =
      AwsError.unwrapOptionField("bufferingHints", bufferingHints)
    def getCompressionFormat
        : ZIO[Any, AwsError, zio.aws.firehose.model.CompressionFormat] =
      AwsError.unwrapOptionField("compressionFormat", compressionFormat)
    def getEncryptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.EncryptionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionConfiguration",
      encryptionConfiguration
    )
    def getCloudWatchLoggingOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudWatchLoggingOptions",
      cloudWatchLoggingOptions
    )
    def getProcessingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.ProcessingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "processingConfiguration",
      processingConfiguration
    )
    def getS3BackupMode
        : ZIO[Any, AwsError, zio.aws.firehose.model.S3BackupMode] =
      AwsError.unwrapOptionField("s3BackupMode", s3BackupMode)
    def getS3BackupUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.S3DestinationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField("s3BackupUpdate", s3BackupUpdate)
    def getDataFormatConversionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.DataFormatConversionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dataFormatConversionConfiguration",
      dataFormatConversionConfiguration
    )
    def getDynamicPartitioningConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.DynamicPartitioningConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dynamicPartitioningConfiguration",
      dynamicPartitioningConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.ExtendedS3DestinationUpdate
  ) extends zio.aws.firehose.model.ExtendedS3DestinationUpdate.ReadOnly {
    override val roleARN: Option[RoleARN] = scala
      .Option(impl.roleARN())
      .map(value => zio.aws.firehose.model.primitives.RoleARN(value))
    override val bucketARN: Option[BucketARN] = scala
      .Option(impl.bucketARN())
      .map(value => zio.aws.firehose.model.primitives.BucketARN(value))
    override val prefix: Option[Prefix] = scala
      .Option(impl.prefix())
      .map(value => zio.aws.firehose.model.primitives.Prefix(value))
    override val errorOutputPrefix: Option[ErrorOutputPrefix] = scala
      .Option(impl.errorOutputPrefix())
      .map(value => zio.aws.firehose.model.primitives.ErrorOutputPrefix(value))
    override val bufferingHints
        : Option[zio.aws.firehose.model.BufferingHints.ReadOnly] = scala
      .Option(impl.bufferingHints())
      .map(value => zio.aws.firehose.model.BufferingHints.wrap(value))
    override val compressionFormat
        : Option[zio.aws.firehose.model.CompressionFormat] = scala
      .Option(impl.compressionFormat())
      .map(value => zio.aws.firehose.model.CompressionFormat.wrap(value))
    override val encryptionConfiguration
        : Option[zio.aws.firehose.model.EncryptionConfiguration.ReadOnly] =
      scala
        .Option(impl.encryptionConfiguration())
        .map(value =>
          zio.aws.firehose.model.EncryptionConfiguration.wrap(value)
        )
    override val cloudWatchLoggingOptions
        : Option[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly] =
      scala
        .Option(impl.cloudWatchLoggingOptions())
        .map(value =>
          zio.aws.firehose.model.CloudWatchLoggingOptions.wrap(value)
        )
    override val processingConfiguration
        : Option[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly] =
      scala
        .Option(impl.processingConfiguration())
        .map(value =>
          zio.aws.firehose.model.ProcessingConfiguration.wrap(value)
        )
    override val s3BackupMode: Option[zio.aws.firehose.model.S3BackupMode] =
      scala
        .Option(impl.s3BackupMode())
        .map(value => zio.aws.firehose.model.S3BackupMode.wrap(value))
    override val s3BackupUpdate
        : Option[zio.aws.firehose.model.S3DestinationUpdate.ReadOnly] = scala
      .Option(impl.s3BackupUpdate())
      .map(value => zio.aws.firehose.model.S3DestinationUpdate.wrap(value))
    override val dataFormatConversionConfiguration: Option[
      zio.aws.firehose.model.DataFormatConversionConfiguration.ReadOnly
    ] = scala
      .Option(impl.dataFormatConversionConfiguration())
      .map(value =>
        zio.aws.firehose.model.DataFormatConversionConfiguration.wrap(value)
      )
    override val dynamicPartitioningConfiguration: Option[
      zio.aws.firehose.model.DynamicPartitioningConfiguration.ReadOnly
    ] = scala
      .Option(impl.dynamicPartitioningConfiguration())
      .map(value =>
        zio.aws.firehose.model.DynamicPartitioningConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.ExtendedS3DestinationUpdate
  ): zio.aws.firehose.model.ExtendedS3DestinationUpdate.ReadOnly = new Wrapper(
    impl
  )
}
