package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class FailureDescription(
    `type`: zio.aws.firehose.model.DeliveryStreamFailureType,
    details: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.FailureDescription = {
    import FailureDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.FailureDescription
      .builder()
      .`type`(`type`.unwrap)
      .details(NonEmptyString.unwrap(details): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.FailureDescription.ReadOnly =
    zio.aws.firehose.model.FailureDescription.wrap(buildAwsValue())
}
object FailureDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.FailureDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.FailureDescription =
      zio.aws.firehose.model.FailureDescription(`type`, details)
    def `type`: zio.aws.firehose.model.DeliveryStreamFailureType
    def details: NonEmptyString
    def getType
        : ZIO[Any, Nothing, zio.aws.firehose.model.DeliveryStreamFailureType] =
      ZIO.succeed(`type`)
    def getDetails: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(details)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.FailureDescription
  ) extends zio.aws.firehose.model.FailureDescription.ReadOnly {
    override val `type`: zio.aws.firehose.model.DeliveryStreamFailureType =
      zio.aws.firehose.model.DeliveryStreamFailureType.wrap(impl.`type`())
    override val details: NonEmptyString =
      zio.aws.firehose.model.primitives.NonEmptyString(impl.details())
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.FailureDescription
  ): zio.aws.firehose.model.FailureDescription.ReadOnly = new Wrapper(impl)
}
