package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.{
  HttpEndpointAccessKey,
  HttpEndpointName,
  HttpEndpointUrl
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class HttpEndpointConfiguration(
    url: HttpEndpointUrl,
    name: Option[HttpEndpointName] = None,
    accessKey: Option[HttpEndpointAccessKey] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.HttpEndpointConfiguration = {
    import HttpEndpointConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.HttpEndpointConfiguration
      .builder()
      .url(HttpEndpointUrl.unwrap(url): java.lang.String)
      .optionallyWith(
        name.map(value => HttpEndpointName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        accessKey.map(value =>
          HttpEndpointAccessKey.unwrap(value): java.lang.String
        )
      )(_.accessKey)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.HttpEndpointConfiguration.ReadOnly =
    zio.aws.firehose.model.HttpEndpointConfiguration.wrap(buildAwsValue())
}
object HttpEndpointConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.HttpEndpointConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.HttpEndpointConfiguration =
      zio.aws.firehose.model.HttpEndpointConfiguration(
        url,
        name.map(value => value),
        accessKey.map(value => value)
      )
    def url: HttpEndpointUrl
    def name: Option[HttpEndpointName]
    def accessKey: Option[HttpEndpointAccessKey]
    def getUrl: ZIO[Any, Nothing, HttpEndpointUrl] = ZIO.succeed(url)
    def getName: ZIO[Any, AwsError, HttpEndpointName] =
      AwsError.unwrapOptionField("name", name)
    def getAccessKey: ZIO[Any, AwsError, HttpEndpointAccessKey] =
      AwsError.unwrapOptionField("accessKey", accessKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.HttpEndpointConfiguration
  ) extends zio.aws.firehose.model.HttpEndpointConfiguration.ReadOnly {
    override val url: HttpEndpointUrl =
      zio.aws.firehose.model.primitives.HttpEndpointUrl(impl.url())
    override val name: Option[HttpEndpointName] = scala
      .Option(impl.name())
      .map(value => zio.aws.firehose.model.primitives.HttpEndpointName(value))
    override val accessKey: Option[HttpEndpointAccessKey] = scala
      .Option(impl.accessKey())
      .map(value =>
        zio.aws.firehose.model.primitives.HttpEndpointAccessKey(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.HttpEndpointConfiguration
  ): zio.aws.firehose.model.HttpEndpointConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
