package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.{HttpEndpointName, HttpEndpointUrl}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class HttpEndpointDescription(
    url: Option[HttpEndpointUrl] = None,
    name: Option[HttpEndpointName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.HttpEndpointDescription = {
    import HttpEndpointDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.HttpEndpointDescription
      .builder()
      .optionallyWith(
        url.map(value => HttpEndpointUrl.unwrap(value): java.lang.String)
      )(_.url)
      .optionallyWith(
        name.map(value => HttpEndpointName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.HttpEndpointDescription.ReadOnly =
    zio.aws.firehose.model.HttpEndpointDescription.wrap(buildAwsValue())
}
object HttpEndpointDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.HttpEndpointDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.HttpEndpointDescription =
      zio.aws.firehose.model.HttpEndpointDescription(
        url.map(value => value),
        name.map(value => value)
      )
    def url: Option[HttpEndpointUrl]
    def name: Option[HttpEndpointName]
    def getUrl: ZIO[Any, AwsError, HttpEndpointUrl] =
      AwsError.unwrapOptionField("url", url)
    def getName: ZIO[Any, AwsError, HttpEndpointName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.HttpEndpointDescription
  ) extends zio.aws.firehose.model.HttpEndpointDescription.ReadOnly {
    override val url: Option[HttpEndpointUrl] = scala
      .Option(impl.url())
      .map(value => zio.aws.firehose.model.primitives.HttpEndpointUrl(value))
    override val name: Option[HttpEndpointName] = scala
      .Option(impl.name())
      .map(value => zio.aws.firehose.model.primitives.HttpEndpointName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.HttpEndpointDescription
  ): zio.aws.firehose.model.HttpEndpointDescription.ReadOnly = new Wrapper(impl)
}
