package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.RoleARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class HttpEndpointDestinationDescription(
    endpointConfiguration: Option[
      zio.aws.firehose.model.HttpEndpointDescription
    ] = None,
    bufferingHints: Option[zio.aws.firehose.model.HttpEndpointBufferingHints] =
      None,
    cloudWatchLoggingOptions: Option[
      zio.aws.firehose.model.CloudWatchLoggingOptions
    ] = None,
    requestConfiguration: Option[
      zio.aws.firehose.model.HttpEndpointRequestConfiguration
    ] = None,
    processingConfiguration: Option[
      zio.aws.firehose.model.ProcessingConfiguration
    ] = None,
    roleARN: Option[RoleARN] = None,
    retryOptions: Option[zio.aws.firehose.model.HttpEndpointRetryOptions] =
      None,
    s3BackupMode: Option[zio.aws.firehose.model.HttpEndpointS3BackupMode] =
      None,
    s3DestinationDescription: Option[
      zio.aws.firehose.model.S3DestinationDescription
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.HttpEndpointDestinationDescription = {
    import HttpEndpointDestinationDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.HttpEndpointDestinationDescription
      .builder()
      .optionallyWith(
        endpointConfiguration.map(value => value.buildAwsValue())
      )(_.endpointConfiguration)
      .optionallyWith(bufferingHints.map(value => value.buildAwsValue()))(
        _.bufferingHints
      )
      .optionallyWith(
        cloudWatchLoggingOptions.map(value => value.buildAwsValue())
      )(_.cloudWatchLoggingOptions)
      .optionallyWith(requestConfiguration.map(value => value.buildAwsValue()))(
        _.requestConfiguration
      )
      .optionallyWith(
        processingConfiguration.map(value => value.buildAwsValue())
      )(_.processingConfiguration)
      .optionallyWith(
        roleARN.map(value => RoleARN.unwrap(value): java.lang.String)
      )(_.roleARN)
      .optionallyWith(retryOptions.map(value => value.buildAwsValue()))(
        _.retryOptions
      )
      .optionallyWith(s3BackupMode.map(value => value.unwrap))(_.s3BackupMode)
      .optionallyWith(
        s3DestinationDescription.map(value => value.buildAwsValue())
      )(_.s3DestinationDescription)
      .build()
  }
  def asReadOnly
      : zio.aws.firehose.model.HttpEndpointDestinationDescription.ReadOnly =
    zio.aws.firehose.model.HttpEndpointDestinationDescription
      .wrap(buildAwsValue())
}
object HttpEndpointDestinationDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.HttpEndpointDestinationDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.HttpEndpointDestinationDescription =
      zio.aws.firehose.model.HttpEndpointDestinationDescription(
        endpointConfiguration.map(value => value.asEditable),
        bufferingHints.map(value => value.asEditable),
        cloudWatchLoggingOptions.map(value => value.asEditable),
        requestConfiguration.map(value => value.asEditable),
        processingConfiguration.map(value => value.asEditable),
        roleARN.map(value => value),
        retryOptions.map(value => value.asEditable),
        s3BackupMode.map(value => value),
        s3DestinationDescription.map(value => value.asEditable)
      )
    def endpointConfiguration
        : Option[zio.aws.firehose.model.HttpEndpointDescription.ReadOnly]
    def bufferingHints
        : Option[zio.aws.firehose.model.HttpEndpointBufferingHints.ReadOnly]
    def cloudWatchLoggingOptions
        : Option[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly]
    def requestConfiguration: Option[
      zio.aws.firehose.model.HttpEndpointRequestConfiguration.ReadOnly
    ]
    def processingConfiguration
        : Option[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly]
    def roleARN: Option[RoleARN]
    def retryOptions
        : Option[zio.aws.firehose.model.HttpEndpointRetryOptions.ReadOnly]
    def s3BackupMode: Option[zio.aws.firehose.model.HttpEndpointS3BackupMode]
    def s3DestinationDescription
        : Option[zio.aws.firehose.model.S3DestinationDescription.ReadOnly]
    def getEndpointConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.HttpEndpointDescription.ReadOnly
    ] =
      AwsError.unwrapOptionField("endpointConfiguration", endpointConfiguration)
    def getBufferingHints: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.HttpEndpointBufferingHints.ReadOnly
    ] = AwsError.unwrapOptionField("bufferingHints", bufferingHints)
    def getCloudWatchLoggingOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudWatchLoggingOptions",
      cloudWatchLoggingOptions
    )
    def getRequestConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.HttpEndpointRequestConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("requestConfiguration", requestConfiguration)
    def getProcessingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.ProcessingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "processingConfiguration",
      processingConfiguration
    )
    def getRoleARN: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("roleARN", roleARN)
    def getRetryOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.HttpEndpointRetryOptions.ReadOnly
    ] = AwsError.unwrapOptionField("retryOptions", retryOptions)
    def getS3BackupMode
        : ZIO[Any, AwsError, zio.aws.firehose.model.HttpEndpointS3BackupMode] =
      AwsError.unwrapOptionField("s3BackupMode", s3BackupMode)
    def getS3DestinationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.S3DestinationDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "s3DestinationDescription",
      s3DestinationDescription
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.HttpEndpointDestinationDescription
  ) extends zio.aws.firehose.model.HttpEndpointDestinationDescription.ReadOnly {
    override val endpointConfiguration
        : Option[zio.aws.firehose.model.HttpEndpointDescription.ReadOnly] =
      scala
        .Option(impl.endpointConfiguration())
        .map(value =>
          zio.aws.firehose.model.HttpEndpointDescription.wrap(value)
        )
    override val bufferingHints
        : Option[zio.aws.firehose.model.HttpEndpointBufferingHints.ReadOnly] =
      scala
        .Option(impl.bufferingHints())
        .map(value =>
          zio.aws.firehose.model.HttpEndpointBufferingHints.wrap(value)
        )
    override val cloudWatchLoggingOptions
        : Option[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly] =
      scala
        .Option(impl.cloudWatchLoggingOptions())
        .map(value =>
          zio.aws.firehose.model.CloudWatchLoggingOptions.wrap(value)
        )
    override val requestConfiguration: Option[
      zio.aws.firehose.model.HttpEndpointRequestConfiguration.ReadOnly
    ] = scala
      .Option(impl.requestConfiguration())
      .map(value =>
        zio.aws.firehose.model.HttpEndpointRequestConfiguration.wrap(value)
      )
    override val processingConfiguration
        : Option[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly] =
      scala
        .Option(impl.processingConfiguration())
        .map(value =>
          zio.aws.firehose.model.ProcessingConfiguration.wrap(value)
        )
    override val roleARN: Option[RoleARN] = scala
      .Option(impl.roleARN())
      .map(value => zio.aws.firehose.model.primitives.RoleARN(value))
    override val retryOptions
        : Option[zio.aws.firehose.model.HttpEndpointRetryOptions.ReadOnly] =
      scala
        .Option(impl.retryOptions())
        .map(value =>
          zio.aws.firehose.model.HttpEndpointRetryOptions.wrap(value)
        )
    override val s3BackupMode
        : Option[zio.aws.firehose.model.HttpEndpointS3BackupMode] = scala
      .Option(impl.s3BackupMode())
      .map(value => zio.aws.firehose.model.HttpEndpointS3BackupMode.wrap(value))
    override val s3DestinationDescription
        : Option[zio.aws.firehose.model.S3DestinationDescription.ReadOnly] =
      scala
        .Option(impl.s3DestinationDescription())
        .map(value =>
          zio.aws.firehose.model.S3DestinationDescription.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.HttpEndpointDestinationDescription
  ): zio.aws.firehose.model.HttpEndpointDestinationDescription.ReadOnly =
    new Wrapper(impl)
}
