package zio.aws.firehose.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class HttpEndpointRequestConfiguration(
    contentEncoding: Option[zio.aws.firehose.model.ContentEncoding] = None,
    commonAttributes: Option[
      Iterable[zio.aws.firehose.model.HttpEndpointCommonAttribute]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.HttpEndpointRequestConfiguration = {
    import HttpEndpointRequestConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.HttpEndpointRequestConfiguration
      .builder()
      .optionallyWith(contentEncoding.map(value => value.unwrap))(
        _.contentEncoding
      )
      .optionallyWith(
        commonAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.commonAttributes)
      .build()
  }
  def asReadOnly
      : zio.aws.firehose.model.HttpEndpointRequestConfiguration.ReadOnly =
    zio.aws.firehose.model.HttpEndpointRequestConfiguration
      .wrap(buildAwsValue())
}
object HttpEndpointRequestConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.HttpEndpointRequestConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.HttpEndpointRequestConfiguration =
      zio.aws.firehose.model.HttpEndpointRequestConfiguration(
        contentEncoding.map(value => value),
        commonAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def contentEncoding: Option[zio.aws.firehose.model.ContentEncoding]
    def commonAttributes: Option[
      List[zio.aws.firehose.model.HttpEndpointCommonAttribute.ReadOnly]
    ]
    def getContentEncoding
        : ZIO[Any, AwsError, zio.aws.firehose.model.ContentEncoding] =
      AwsError.unwrapOptionField("contentEncoding", contentEncoding)
    def getCommonAttributes: ZIO[Any, AwsError, List[
      zio.aws.firehose.model.HttpEndpointCommonAttribute.ReadOnly
    ]] = AwsError.unwrapOptionField("commonAttributes", commonAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.HttpEndpointRequestConfiguration
  ) extends zio.aws.firehose.model.HttpEndpointRequestConfiguration.ReadOnly {
    override val contentEncoding
        : Option[zio.aws.firehose.model.ContentEncoding] = scala
      .Option(impl.contentEncoding())
      .map(value => zio.aws.firehose.model.ContentEncoding.wrap(value))
    override val commonAttributes: Option[
      List[zio.aws.firehose.model.HttpEndpointCommonAttribute.ReadOnly]
    ] = scala
      .Option(impl.commonAttributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.firehose.model.HttpEndpointCommonAttribute.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.HttpEndpointRequestConfiguration
  ): zio.aws.firehose.model.HttpEndpointRequestConfiguration.ReadOnly =
    new Wrapper(impl)
}
