package zio.aws.firehose.model
import java.lang.Integer
import zio.aws.firehose.model.primitives.HttpEndpointRetryDurationInSeconds
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class HttpEndpointRetryOptions(
    durationInSeconds: Option[HttpEndpointRetryDurationInSeconds] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.HttpEndpointRetryOptions = {
    import HttpEndpointRetryOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.HttpEndpointRetryOptions
      .builder()
      .optionallyWith(
        durationInSeconds.map(value =>
          HttpEndpointRetryDurationInSeconds.unwrap(value): Integer
        )
      )(_.durationInSeconds)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.HttpEndpointRetryOptions.ReadOnly =
    zio.aws.firehose.model.HttpEndpointRetryOptions.wrap(buildAwsValue())
}
object HttpEndpointRetryOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.HttpEndpointRetryOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.HttpEndpointRetryOptions =
      zio.aws.firehose.model
        .HttpEndpointRetryOptions(durationInSeconds.map(value => value))
    def durationInSeconds: Option[HttpEndpointRetryDurationInSeconds]
    def getDurationInSeconds
        : ZIO[Any, AwsError, HttpEndpointRetryDurationInSeconds] =
      AwsError.unwrapOptionField("durationInSeconds", durationInSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.HttpEndpointRetryOptions
  ) extends zio.aws.firehose.model.HttpEndpointRetryOptions.ReadOnly {
    override val durationInSeconds: Option[HttpEndpointRetryDurationInSeconds] =
      scala
        .Option(impl.durationInSeconds())
        .map(value =>
          zio.aws.firehose.model.primitives
            .HttpEndpointRetryDurationInSeconds(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.HttpEndpointRetryOptions
  ): zio.aws.firehose.model.HttpEndpointRetryOptions.ReadOnly = new Wrapper(
    impl
  )
}
