package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.{RoleARN, KinesisStreamARN}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class KinesisStreamSourceConfiguration(
    kinesisStreamARN: KinesisStreamARN,
    roleARN: RoleARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.KinesisStreamSourceConfiguration = {
    import KinesisStreamSourceConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.KinesisStreamSourceConfiguration
      .builder()
      .kinesisStreamARN(
        KinesisStreamARN.unwrap(kinesisStreamARN): java.lang.String
      )
      .roleARN(RoleARN.unwrap(roleARN): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.firehose.model.KinesisStreamSourceConfiguration.ReadOnly =
    zio.aws.firehose.model.KinesisStreamSourceConfiguration
      .wrap(buildAwsValue())
}
object KinesisStreamSourceConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.KinesisStreamSourceConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.KinesisStreamSourceConfiguration =
      zio.aws.firehose.model
        .KinesisStreamSourceConfiguration(kinesisStreamARN, roleARN)
    def kinesisStreamARN: KinesisStreamARN
    def roleARN: RoleARN
    def getKinesisStreamARN: ZIO[Any, Nothing, KinesisStreamARN] =
      ZIO.succeed(kinesisStreamARN)
    def getRoleARN: ZIO[Any, Nothing, RoleARN] = ZIO.succeed(roleARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.KinesisStreamSourceConfiguration
  ) extends zio.aws.firehose.model.KinesisStreamSourceConfiguration.ReadOnly {
    override val kinesisStreamARN: KinesisStreamARN =
      zio.aws.firehose.model.primitives
        .KinesisStreamARN(impl.kinesisStreamARN())
    override val roleARN: RoleARN =
      zio.aws.firehose.model.primitives.RoleARN(impl.roleARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.KinesisStreamSourceConfiguration
  ): zio.aws.firehose.model.KinesisStreamSourceConfiguration.ReadOnly =
    new Wrapper(impl)
}
