package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.{
  DeliveryStartTimestamp,
  RoleARN,
  KinesisStreamARN
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class KinesisStreamSourceDescription(
    kinesisStreamARN: Option[KinesisStreamARN] = None,
    roleARN: Option[RoleARN] = None,
    deliveryStartTimestamp: Option[DeliveryStartTimestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.KinesisStreamSourceDescription = {
    import KinesisStreamSourceDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.KinesisStreamSourceDescription
      .builder()
      .optionallyWith(
        kinesisStreamARN.map(value =>
          KinesisStreamARN.unwrap(value): java.lang.String
        )
      )(_.kinesisStreamARN)
      .optionallyWith(
        roleARN.map(value => RoleARN.unwrap(value): java.lang.String)
      )(_.roleARN)
      .optionallyWith(
        deliveryStartTimestamp.map(value =>
          DeliveryStartTimestamp.unwrap(value): Instant
        )
      )(_.deliveryStartTimestamp)
      .build()
  }
  def asReadOnly
      : zio.aws.firehose.model.KinesisStreamSourceDescription.ReadOnly =
    zio.aws.firehose.model.KinesisStreamSourceDescription.wrap(buildAwsValue())
}
object KinesisStreamSourceDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.KinesisStreamSourceDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.KinesisStreamSourceDescription =
      zio.aws.firehose.model.KinesisStreamSourceDescription(
        kinesisStreamARN.map(value => value),
        roleARN.map(value => value),
        deliveryStartTimestamp.map(value => value)
      )
    def kinesisStreamARN: Option[KinesisStreamARN]
    def roleARN: Option[RoleARN]
    def deliveryStartTimestamp: Option[DeliveryStartTimestamp]
    def getKinesisStreamARN: ZIO[Any, AwsError, KinesisStreamARN] =
      AwsError.unwrapOptionField("kinesisStreamARN", kinesisStreamARN)
    def getRoleARN: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("roleARN", roleARN)
    def getDeliveryStartTimestamp: ZIO[Any, AwsError, DeliveryStartTimestamp] =
      AwsError.unwrapOptionField(
        "deliveryStartTimestamp",
        deliveryStartTimestamp
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.KinesisStreamSourceDescription
  ) extends zio.aws.firehose.model.KinesisStreamSourceDescription.ReadOnly {
    override val kinesisStreamARN: Option[KinesisStreamARN] = scala
      .Option(impl.kinesisStreamARN())
      .map(value => zio.aws.firehose.model.primitives.KinesisStreamARN(value))
    override val roleARN: Option[RoleARN] = scala
      .Option(impl.roleARN())
      .map(value => zio.aws.firehose.model.primitives.RoleARN(value))
    override val deliveryStartTimestamp: Option[DeliveryStartTimestamp] = scala
      .Option(impl.deliveryStartTimestamp())
      .map(value =>
        zio.aws.firehose.model.primitives.DeliveryStartTimestamp(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.KinesisStreamSourceDescription
  ): zio.aws.firehose.model.KinesisStreamSourceDescription.ReadOnly =
    new Wrapper(impl)
}
