package zio.aws.firehose.model
import java.lang.Integer
import zio.aws.firehose.model.primitives.{
  DeliveryStreamName,
  ListDeliveryStreamsInputLimit
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListDeliveryStreamsRequest(
    limit: Option[ListDeliveryStreamsInputLimit] = None,
    deliveryStreamType: Option[zio.aws.firehose.model.DeliveryStreamType] =
      None,
    exclusiveStartDeliveryStreamName: Option[DeliveryStreamName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.ListDeliveryStreamsRequest = {
    import ListDeliveryStreamsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.ListDeliveryStreamsRequest
      .builder()
      .optionallyWith(
        limit.map(value => ListDeliveryStreamsInputLimit.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(deliveryStreamType.map(value => value.unwrap))(
        _.deliveryStreamType
      )
      .optionallyWith(
        exclusiveStartDeliveryStreamName.map(value =>
          DeliveryStreamName.unwrap(value): java.lang.String
        )
      )(_.exclusiveStartDeliveryStreamName)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.ListDeliveryStreamsRequest.ReadOnly =
    zio.aws.firehose.model.ListDeliveryStreamsRequest.wrap(buildAwsValue())
}
object ListDeliveryStreamsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.ListDeliveryStreamsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.ListDeliveryStreamsRequest =
      zio.aws.firehose.model.ListDeliveryStreamsRequest(
        limit.map(value => value),
        deliveryStreamType.map(value => value),
        exclusiveStartDeliveryStreamName.map(value => value)
      )
    def limit: Option[ListDeliveryStreamsInputLimit]
    def deliveryStreamType: Option[zio.aws.firehose.model.DeliveryStreamType]
    def exclusiveStartDeliveryStreamName: Option[DeliveryStreamName]
    def getLimit: ZIO[Any, AwsError, ListDeliveryStreamsInputLimit] =
      AwsError.unwrapOptionField("limit", limit)
    def getDeliveryStreamType
        : ZIO[Any, AwsError, zio.aws.firehose.model.DeliveryStreamType] =
      AwsError.unwrapOptionField("deliveryStreamType", deliveryStreamType)
    def getExclusiveStartDeliveryStreamName
        : ZIO[Any, AwsError, DeliveryStreamName] = AwsError.unwrapOptionField(
      "exclusiveStartDeliveryStreamName",
      exclusiveStartDeliveryStreamName
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.ListDeliveryStreamsRequest
  ) extends zio.aws.firehose.model.ListDeliveryStreamsRequest.ReadOnly {
    override val limit: Option[ListDeliveryStreamsInputLimit] = scala
      .Option(impl.limit())
      .map(value =>
        zio.aws.firehose.model.primitives.ListDeliveryStreamsInputLimit(value)
      )
    override val deliveryStreamType
        : Option[zio.aws.firehose.model.DeliveryStreamType] = scala
      .Option(impl.deliveryStreamType())
      .map(value => zio.aws.firehose.model.DeliveryStreamType.wrap(value))
    override val exclusiveStartDeliveryStreamName: Option[DeliveryStreamName] =
      scala
        .Option(impl.exclusiveStartDeliveryStreamName())
        .map(value =>
          zio.aws.firehose.model.primitives.DeliveryStreamName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.ListDeliveryStreamsRequest
  ): zio.aws.firehose.model.ListDeliveryStreamsRequest.ReadOnly = new Wrapper(
    impl
  )
}
