package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.{
  NonEmptyString,
  NonEmptyStringWithoutWhitespace,
  BooleanObject
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class OpenXJsonSerDe(
    convertDotsInJsonKeysToUnderscores: Option[BooleanObject] = None,
    caseInsensitive: Option[BooleanObject] = None,
    columnToJsonKeyMappings: Option[
      Map[NonEmptyStringWithoutWhitespace, NonEmptyString]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.OpenXJsonSerDe = {
    import OpenXJsonSerDe.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.OpenXJsonSerDe
      .builder()
      .optionallyWith(
        convertDotsInJsonKeysToUnderscores.map(value =>
          BooleanObject.unwrap(value): java.lang.Boolean
        )
      )(_.convertDotsInJsonKeysToUnderscores)
      .optionallyWith(
        caseInsensitive.map(value =>
          BooleanObject.unwrap(value): java.lang.Boolean
        )
      )(_.caseInsensitive)
      .optionallyWith(
        columnToJsonKeyMappings.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyStringWithoutWhitespace
                .unwrap(key): java.lang.String) -> (NonEmptyString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.columnToJsonKeyMappings)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.OpenXJsonSerDe.ReadOnly =
    zio.aws.firehose.model.OpenXJsonSerDe.wrap(buildAwsValue())
}
object OpenXJsonSerDe {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.OpenXJsonSerDe
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.OpenXJsonSerDe =
      zio.aws.firehose.model.OpenXJsonSerDe(
        convertDotsInJsonKeysToUnderscores.map(value => value),
        caseInsensitive.map(value => value),
        columnToJsonKeyMappings.map(value => value)
      )
    def convertDotsInJsonKeysToUnderscores: Option[BooleanObject]
    def caseInsensitive: Option[BooleanObject]
    def columnToJsonKeyMappings
        : Option[Map[NonEmptyStringWithoutWhitespace, NonEmptyString]]
    def getConvertDotsInJsonKeysToUnderscores
        : ZIO[Any, AwsError, BooleanObject] = AwsError.unwrapOptionField(
      "convertDotsInJsonKeysToUnderscores",
      convertDotsInJsonKeysToUnderscores
    )
    def getCaseInsensitive: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("caseInsensitive", caseInsensitive)
    def getColumnToJsonKeyMappings: ZIO[Any, AwsError, Map[
      NonEmptyStringWithoutWhitespace,
      NonEmptyString
    ]] = AwsError.unwrapOptionField(
      "columnToJsonKeyMappings",
      columnToJsonKeyMappings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.OpenXJsonSerDe
  ) extends zio.aws.firehose.model.OpenXJsonSerDe.ReadOnly {
    override val convertDotsInJsonKeysToUnderscores: Option[BooleanObject] =
      scala
        .Option(impl.convertDotsInJsonKeysToUnderscores())
        .map(value => zio.aws.firehose.model.primitives.BooleanObject(value))
    override val caseInsensitive: Option[BooleanObject] = scala
      .Option(impl.caseInsensitive())
      .map(value => zio.aws.firehose.model.primitives.BooleanObject(value))
    override val columnToJsonKeyMappings
        : Option[Map[NonEmptyStringWithoutWhitespace, NonEmptyString]] = scala
      .Option(impl.columnToJsonKeyMappings())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.firehose.model.primitives.NonEmptyStringWithoutWhitespace(
              key
            ) -> zio.aws.firehose.model.primitives.NonEmptyString(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.OpenXJsonSerDe
  ): zio.aws.firehose.model.OpenXJsonSerDe.ReadOnly = new Wrapper(impl)
}
