package zio.aws.firehose.model
import scala.jdk.CollectionConverters.*
sealed trait OrcFormatVersion {
  def unwrap: software.amazon.awssdk.services.firehose.model.OrcFormatVersion
}
object OrcFormatVersion {
  def wrap(
      value: software.amazon.awssdk.services.firehose.model.OrcFormatVersion
  ): zio.aws.firehose.model.OrcFormatVersion = value match {
    case software.amazon.awssdk.services.firehose.model.OrcFormatVersion.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.firehose.model.OrcFormatVersion.V0_11 =>
      val r = V0_11
      r
    case software.amazon.awssdk.services.firehose.model.OrcFormatVersion.V0_12 =>
      val r = V0_12
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.firehose.model.OrcFormatVersion {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.OrcFormatVersion =
      software.amazon.awssdk.services.firehose.model.OrcFormatVersion.UNKNOWN_TO_SDK_VERSION
  }
  case object V0_11 extends zio.aws.firehose.model.OrcFormatVersion {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.OrcFormatVersion =
      software.amazon.awssdk.services.firehose.model.OrcFormatVersion.V0_11
  }
  case object V0_12 extends zio.aws.firehose.model.OrcFormatVersion {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.OrcFormatVersion =
      software.amazon.awssdk.services.firehose.model.OrcFormatVersion.V0_12
  }
}
