package zio.aws.firehose.model
import java.lang.Integer
import zio.aws.firehose.model.primitives.{
  OrcStripeSizeBytes,
  BooleanObject,
  OrcRowIndexStride,
  NonEmptyStringWithoutWhitespace,
  BlockSizeBytes,
  Proportion
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class OrcSerDe(
    stripeSizeBytes: Option[OrcStripeSizeBytes] = None,
    blockSizeBytes: Option[BlockSizeBytes] = None,
    rowIndexStride: Option[OrcRowIndexStride] = None,
    enablePadding: Option[BooleanObject] = None,
    paddingTolerance: Option[Proportion] = None,
    compression: Option[zio.aws.firehose.model.OrcCompression] = None,
    bloomFilterColumns: Option[Iterable[NonEmptyStringWithoutWhitespace]] =
      None,
    bloomFilterFalsePositiveProbability: Option[Proportion] = None,
    dictionaryKeyThreshold: Option[Proportion] = None,
    formatVersion: Option[zio.aws.firehose.model.OrcFormatVersion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.OrcSerDe = {
    import OrcSerDe.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.OrcSerDe
      .builder()
      .optionallyWith(
        stripeSizeBytes.map(value => OrcStripeSizeBytes.unwrap(value): Integer)
      )(_.stripeSizeBytes)
      .optionallyWith(
        blockSizeBytes.map(value => BlockSizeBytes.unwrap(value): Integer)
      )(_.blockSizeBytes)
      .optionallyWith(
        rowIndexStride.map(value => OrcRowIndexStride.unwrap(value): Integer)
      )(_.rowIndexStride)
      .optionallyWith(
        enablePadding.map(value =>
          BooleanObject.unwrap(value): java.lang.Boolean
        )
      )(_.enablePadding)
      .optionallyWith(
        paddingTolerance.map(value =>
          Proportion.unwrap(value): java.lang.Double
        )
      )(_.paddingTolerance)
      .optionallyWith(compression.map(value => value.unwrap))(_.compression)
      .optionallyWith(
        bloomFilterColumns.map(value =>
          value.map { item =>
            NonEmptyStringWithoutWhitespace.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.bloomFilterColumns)
      .optionallyWith(
        bloomFilterFalsePositiveProbability.map(value =>
          Proportion.unwrap(value): java.lang.Double
        )
      )(_.bloomFilterFalsePositiveProbability)
      .optionallyWith(
        dictionaryKeyThreshold.map(value =>
          Proportion.unwrap(value): java.lang.Double
        )
      )(_.dictionaryKeyThreshold)
      .optionallyWith(formatVersion.map(value => value.unwrap))(_.formatVersion)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.OrcSerDe.ReadOnly =
    zio.aws.firehose.model.OrcSerDe.wrap(buildAwsValue())
}
object OrcSerDe {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.firehose.model.OrcSerDe] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.OrcSerDe =
      zio.aws.firehose.model.OrcSerDe(
        stripeSizeBytes.map(value => value),
        blockSizeBytes.map(value => value),
        rowIndexStride.map(value => value),
        enablePadding.map(value => value),
        paddingTolerance.map(value => value),
        compression.map(value => value),
        bloomFilterColumns.map(value => value),
        bloomFilterFalsePositiveProbability.map(value => value),
        dictionaryKeyThreshold.map(value => value),
        formatVersion.map(value => value)
      )
    def stripeSizeBytes: Option[OrcStripeSizeBytes]
    def blockSizeBytes: Option[BlockSizeBytes]
    def rowIndexStride: Option[OrcRowIndexStride]
    def enablePadding: Option[BooleanObject]
    def paddingTolerance: Option[Proportion]
    def compression: Option[zio.aws.firehose.model.OrcCompression]
    def bloomFilterColumns: Option[List[NonEmptyStringWithoutWhitespace]]
    def bloomFilterFalsePositiveProbability: Option[Proportion]
    def dictionaryKeyThreshold: Option[Proportion]
    def formatVersion: Option[zio.aws.firehose.model.OrcFormatVersion]
    def getStripeSizeBytes: ZIO[Any, AwsError, OrcStripeSizeBytes] =
      AwsError.unwrapOptionField("stripeSizeBytes", stripeSizeBytes)
    def getBlockSizeBytes: ZIO[Any, AwsError, BlockSizeBytes] =
      AwsError.unwrapOptionField("blockSizeBytes", blockSizeBytes)
    def getRowIndexStride: ZIO[Any, AwsError, OrcRowIndexStride] =
      AwsError.unwrapOptionField("rowIndexStride", rowIndexStride)
    def getEnablePadding: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("enablePadding", enablePadding)
    def getPaddingTolerance: ZIO[Any, AwsError, Proportion] =
      AwsError.unwrapOptionField("paddingTolerance", paddingTolerance)
    def getCompression
        : ZIO[Any, AwsError, zio.aws.firehose.model.OrcCompression] =
      AwsError.unwrapOptionField("compression", compression)
    def getBloomFilterColumns
        : ZIO[Any, AwsError, List[NonEmptyStringWithoutWhitespace]] =
      AwsError.unwrapOptionField("bloomFilterColumns", bloomFilterColumns)
    def getBloomFilterFalsePositiveProbability: ZIO[Any, AwsError, Proportion] =
      AwsError.unwrapOptionField(
        "bloomFilterFalsePositiveProbability",
        bloomFilterFalsePositiveProbability
      )
    def getDictionaryKeyThreshold: ZIO[Any, AwsError, Proportion] = AwsError
      .unwrapOptionField("dictionaryKeyThreshold", dictionaryKeyThreshold)
    def getFormatVersion
        : ZIO[Any, AwsError, zio.aws.firehose.model.OrcFormatVersion] =
      AwsError.unwrapOptionField("formatVersion", formatVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.OrcSerDe
  ) extends zio.aws.firehose.model.OrcSerDe.ReadOnly {
    override val stripeSizeBytes: Option[OrcStripeSizeBytes] = scala
      .Option(impl.stripeSizeBytes())
      .map(value => zio.aws.firehose.model.primitives.OrcStripeSizeBytes(value))
    override val blockSizeBytes: Option[BlockSizeBytes] = scala
      .Option(impl.blockSizeBytes())
      .map(value => zio.aws.firehose.model.primitives.BlockSizeBytes(value))
    override val rowIndexStride: Option[OrcRowIndexStride] = scala
      .Option(impl.rowIndexStride())
      .map(value => zio.aws.firehose.model.primitives.OrcRowIndexStride(value))
    override val enablePadding: Option[BooleanObject] = scala
      .Option(impl.enablePadding())
      .map(value => zio.aws.firehose.model.primitives.BooleanObject(value))
    override val paddingTolerance: Option[Proportion] = scala
      .Option(impl.paddingTolerance())
      .map(value => zio.aws.firehose.model.primitives.Proportion(value))
    override val compression: Option[zio.aws.firehose.model.OrcCompression] =
      scala
        .Option(impl.compression())
        .map(value => zio.aws.firehose.model.OrcCompression.wrap(value))
    override val bloomFilterColumns
        : Option[List[NonEmptyStringWithoutWhitespace]] = scala
      .Option(impl.bloomFilterColumns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.firehose.model.primitives
            .NonEmptyStringWithoutWhitespace(item)
        }.toList
      )
    override val bloomFilterFalsePositiveProbability: Option[Proportion] = scala
      .Option(impl.bloomFilterFalsePositiveProbability())
      .map(value => zio.aws.firehose.model.primitives.Proportion(value))
    override val dictionaryKeyThreshold: Option[Proportion] = scala
      .Option(impl.dictionaryKeyThreshold())
      .map(value => zio.aws.firehose.model.primitives.Proportion(value))
    override val formatVersion
        : Option[zio.aws.firehose.model.OrcFormatVersion] = scala
      .Option(impl.formatVersion())
      .map(value => zio.aws.firehose.model.OrcFormatVersion.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.OrcSerDe
  ): zio.aws.firehose.model.OrcSerDe.ReadOnly = new Wrapper(impl)
}
