package zio.aws.firehose.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class OutputFormatConfiguration(
    serializer: Option[zio.aws.firehose.model.Serializer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.OutputFormatConfiguration = {
    import OutputFormatConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.OutputFormatConfiguration
      .builder()
      .optionallyWith(serializer.map(value => value.buildAwsValue()))(
        _.serializer
      )
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.OutputFormatConfiguration.ReadOnly =
    zio.aws.firehose.model.OutputFormatConfiguration.wrap(buildAwsValue())
}
object OutputFormatConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.OutputFormatConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.OutputFormatConfiguration =
      zio.aws.firehose.model
        .OutputFormatConfiguration(serializer.map(value => value.asEditable))
    def serializer: Option[zio.aws.firehose.model.Serializer.ReadOnly]
    def getSerializer
        : ZIO[Any, AwsError, zio.aws.firehose.model.Serializer.ReadOnly] =
      AwsError.unwrapOptionField("serializer", serializer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.OutputFormatConfiguration
  ) extends zio.aws.firehose.model.OutputFormatConfiguration.ReadOnly {
    override val serializer
        : Option[zio.aws.firehose.model.Serializer.ReadOnly] = scala
      .Option(impl.serializer())
      .map(value => zio.aws.firehose.model.Serializer.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.OutputFormatConfiguration
  ): zio.aws.firehose.model.OutputFormatConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
