package zio.aws.firehose.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Processor(
    `type`: zio.aws.firehose.model.ProcessorType,
    parameters: Option[Iterable[zio.aws.firehose.model.ProcessorParameter]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.Processor = {
    import Processor.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.Processor
      .builder()
      .`type`(`type`.unwrap)
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.Processor.ReadOnly =
    zio.aws.firehose.model.Processor.wrap(buildAwsValue())
}
object Processor {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.Processor
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.Processor =
      zio.aws.firehose.model.Processor(
        `type`,
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def `type`: zio.aws.firehose.model.ProcessorType
    def parameters
        : Option[List[zio.aws.firehose.model.ProcessorParameter.ReadOnly]]
    def getType: ZIO[Any, Nothing, zio.aws.firehose.model.ProcessorType] =
      ZIO.succeed(`type`)
    def getParameters: ZIO[Any, AwsError, List[
      zio.aws.firehose.model.ProcessorParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.Processor
  ) extends zio.aws.firehose.model.Processor.ReadOnly {
    override val `type`: zio.aws.firehose.model.ProcessorType =
      zio.aws.firehose.model.ProcessorType.wrap(impl.`type`())
    override val parameters
        : Option[List[zio.aws.firehose.model.ProcessorParameter.ReadOnly]] =
      scala
        .Option(impl.parameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.firehose.model.ProcessorParameter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.Processor
  ): zio.aws.firehose.model.Processor.ReadOnly = new Wrapper(impl)
}
