package zio.aws.firehose.model
import java.lang.Integer
import zio.aws.firehose.model.primitives.{
  BooleanObject,
  NonNegativeIntegerObject
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutRecordBatchResponse(
    failedPutCount: NonNegativeIntegerObject,
    encrypted: Option[BooleanObject] = None,
    requestResponses: Iterable[
      zio.aws.firehose.model.PutRecordBatchResponseEntry
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.PutRecordBatchResponse = {
    import PutRecordBatchResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.PutRecordBatchResponse
      .builder()
      .failedPutCount(NonNegativeIntegerObject.unwrap(failedPutCount): Integer)
      .optionallyWith(
        encrypted.map(value => BooleanObject.unwrap(value): java.lang.Boolean)
      )(_.encrypted)
      .requestResponses(requestResponses.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.PutRecordBatchResponse.ReadOnly =
    zio.aws.firehose.model.PutRecordBatchResponse.wrap(buildAwsValue())
}
object PutRecordBatchResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.PutRecordBatchResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.PutRecordBatchResponse =
      zio.aws.firehose.model.PutRecordBatchResponse(
        failedPutCount,
        encrypted.map(value => value),
        requestResponses.map { item =>
          item.asEditable
        }
      )
    def failedPutCount: NonNegativeIntegerObject
    def encrypted: Option[BooleanObject]
    def requestResponses
        : List[zio.aws.firehose.model.PutRecordBatchResponseEntry.ReadOnly]
    def getFailedPutCount: ZIO[Any, Nothing, NonNegativeIntegerObject] =
      ZIO.succeed(failedPutCount)
    def getEncrypted: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getRequestResponses: ZIO[Any, Nothing, List[
      zio.aws.firehose.model.PutRecordBatchResponseEntry.ReadOnly
    ]] = ZIO.succeed(requestResponses)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.PutRecordBatchResponse
  ) extends zio.aws.firehose.model.PutRecordBatchResponse.ReadOnly {
    override val failedPutCount: NonNegativeIntegerObject =
      zio.aws.firehose.model.primitives
        .NonNegativeIntegerObject(impl.failedPutCount())
    override val encrypted: Option[BooleanObject] = scala
      .Option(impl.encrypted())
      .map(value => zio.aws.firehose.model.primitives.BooleanObject(value))
    override val requestResponses
        : List[zio.aws.firehose.model.PutRecordBatchResponseEntry.ReadOnly] =
      impl
        .requestResponses()
        .asScala
        .map { item =>
          zio.aws.firehose.model.PutRecordBatchResponseEntry.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.PutRecordBatchResponse
  ): zio.aws.firehose.model.PutRecordBatchResponse.ReadOnly = new Wrapper(impl)
}
