package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.{
  ErrorMessage,
  ErrorCode,
  PutResponseRecordId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutRecordBatchResponseEntry(
    recordId: Option[PutResponseRecordId] = None,
    errorCode: Option[ErrorCode] = None,
    errorMessage: Option[ErrorMessage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.PutRecordBatchResponseEntry = {
    import PutRecordBatchResponseEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.PutRecordBatchResponseEntry
      .builder()
      .optionallyWith(
        recordId.map(value =>
          PutResponseRecordId.unwrap(value): java.lang.String
        )
      )(_.recordId)
      .optionallyWith(
        errorCode.map(value => ErrorCode.unwrap(value): java.lang.String)
      )(_.errorCode)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.PutRecordBatchResponseEntry.ReadOnly =
    zio.aws.firehose.model.PutRecordBatchResponseEntry.wrap(buildAwsValue())
}
object PutRecordBatchResponseEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.PutRecordBatchResponseEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.PutRecordBatchResponseEntry =
      zio.aws.firehose.model.PutRecordBatchResponseEntry(
        recordId.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def recordId: Option[PutResponseRecordId]
    def errorCode: Option[ErrorCode]
    def errorMessage: Option[ErrorMessage]
    def getRecordId: ZIO[Any, AwsError, PutResponseRecordId] =
      AwsError.unwrapOptionField("recordId", recordId)
    def getErrorCode: ZIO[Any, AwsError, ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.PutRecordBatchResponseEntry
  ) extends zio.aws.firehose.model.PutRecordBatchResponseEntry.ReadOnly {
    override val recordId: Option[PutResponseRecordId] = scala
      .Option(impl.recordId())
      .map(value =>
        zio.aws.firehose.model.primitives.PutResponseRecordId(value)
      )
    override val errorCode: Option[ErrorCode] = scala
      .Option(impl.errorCode())
      .map(value => zio.aws.firehose.model.primitives.ErrorCode(value))
    override val errorMessage: Option[ErrorMessage] = scala
      .Option(impl.errorMessage())
      .map(value => zio.aws.firehose.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.PutRecordBatchResponseEntry
  ): zio.aws.firehose.model.PutRecordBatchResponseEntry.ReadOnly = new Wrapper(
    impl
  )
}
