package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.{BooleanObject, PutResponseRecordId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutRecordResponse(
    recordId: PutResponseRecordId,
    encrypted: Option[BooleanObject] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.PutRecordResponse = {
    import PutRecordResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.PutRecordResponse
      .builder()
      .recordId(PutResponseRecordId.unwrap(recordId): java.lang.String)
      .optionallyWith(
        encrypted.map(value => BooleanObject.unwrap(value): java.lang.Boolean)
      )(_.encrypted)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.PutRecordResponse.ReadOnly =
    zio.aws.firehose.model.PutRecordResponse.wrap(buildAwsValue())
}
object PutRecordResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.PutRecordResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.PutRecordResponse =
      zio.aws.firehose.model
        .PutRecordResponse(recordId, encrypted.map(value => value))
    def recordId: PutResponseRecordId
    def encrypted: Option[BooleanObject]
    def getRecordId: ZIO[Any, Nothing, PutResponseRecordId] =
      ZIO.succeed(recordId)
    def getEncrypted: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("encrypted", encrypted)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.PutRecordResponse
  ) extends zio.aws.firehose.model.PutRecordResponse.ReadOnly {
    override val recordId: PutResponseRecordId =
      zio.aws.firehose.model.primitives.PutResponseRecordId(impl.recordId())
    override val encrypted: Option[BooleanObject] = scala
      .Option(impl.encrypted())
      .map(value => zio.aws.firehose.model.primitives.BooleanObject(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.PutRecordResponse
  ): zio.aws.firehose.model.PutRecordResponse.ReadOnly = new Wrapper(impl)
}
