package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.{Username, ClusterJDBCURL, RoleARN}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RedshiftDestinationDescription(
    roleARN: RoleARN,
    clusterJDBCURL: ClusterJDBCURL,
    copyCommand: zio.aws.firehose.model.CopyCommand,
    username: Username,
    retryOptions: Option[zio.aws.firehose.model.RedshiftRetryOptions] = None,
    s3DestinationDescription: zio.aws.firehose.model.S3DestinationDescription,
    processingConfiguration: Option[
      zio.aws.firehose.model.ProcessingConfiguration
    ] = None,
    s3BackupMode: Option[zio.aws.firehose.model.RedshiftS3BackupMode] = None,
    s3BackupDescription: Option[
      zio.aws.firehose.model.S3DestinationDescription
    ] = None,
    cloudWatchLoggingOptions: Option[
      zio.aws.firehose.model.CloudWatchLoggingOptions
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.RedshiftDestinationDescription = {
    import RedshiftDestinationDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.RedshiftDestinationDescription
      .builder()
      .roleARN(RoleARN.unwrap(roleARN): java.lang.String)
      .clusterJDBCURL(ClusterJDBCURL.unwrap(clusterJDBCURL): java.lang.String)
      .copyCommand(copyCommand.buildAwsValue())
      .username(Username.unwrap(username): java.lang.String)
      .optionallyWith(retryOptions.map(value => value.buildAwsValue()))(
        _.retryOptions
      )
      .s3DestinationDescription(s3DestinationDescription.buildAwsValue())
      .optionallyWith(
        processingConfiguration.map(value => value.buildAwsValue())
      )(_.processingConfiguration)
      .optionallyWith(s3BackupMode.map(value => value.unwrap))(_.s3BackupMode)
      .optionallyWith(s3BackupDescription.map(value => value.buildAwsValue()))(
        _.s3BackupDescription
      )
      .optionallyWith(
        cloudWatchLoggingOptions.map(value => value.buildAwsValue())
      )(_.cloudWatchLoggingOptions)
      .build()
  }
  def asReadOnly
      : zio.aws.firehose.model.RedshiftDestinationDescription.ReadOnly =
    zio.aws.firehose.model.RedshiftDestinationDescription.wrap(buildAwsValue())
}
object RedshiftDestinationDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.RedshiftDestinationDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.RedshiftDestinationDescription =
      zio.aws.firehose.model.RedshiftDestinationDescription(
        roleARN,
        clusterJDBCURL,
        copyCommand.asEditable,
        username,
        retryOptions.map(value => value.asEditable),
        s3DestinationDescription.asEditable,
        processingConfiguration.map(value => value.asEditable),
        s3BackupMode.map(value => value),
        s3BackupDescription.map(value => value.asEditable),
        cloudWatchLoggingOptions.map(value => value.asEditable)
      )
    def roleARN: RoleARN
    def clusterJDBCURL: ClusterJDBCURL
    def copyCommand: zio.aws.firehose.model.CopyCommand.ReadOnly
    def username: Username
    def retryOptions
        : Option[zio.aws.firehose.model.RedshiftRetryOptions.ReadOnly]
    def s3DestinationDescription
        : zio.aws.firehose.model.S3DestinationDescription.ReadOnly
    def processingConfiguration
        : Option[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly]
    def s3BackupMode: Option[zio.aws.firehose.model.RedshiftS3BackupMode]
    def s3BackupDescription
        : Option[zio.aws.firehose.model.S3DestinationDescription.ReadOnly]
    def cloudWatchLoggingOptions
        : Option[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly]
    def getRoleARN: ZIO[Any, Nothing, RoleARN] = ZIO.succeed(roleARN)
    def getClusterJDBCURL: ZIO[Any, Nothing, ClusterJDBCURL] =
      ZIO.succeed(clusterJDBCURL)
    def getCopyCommand
        : ZIO[Any, Nothing, zio.aws.firehose.model.CopyCommand.ReadOnly] =
      ZIO.succeed(copyCommand)
    def getUsername: ZIO[Any, Nothing, Username] = ZIO.succeed(username)
    def getRetryOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.RedshiftRetryOptions.ReadOnly
    ] = AwsError.unwrapOptionField("retryOptions", retryOptions)
    def getS3DestinationDescription: ZIO[
      Any,
      Nothing,
      zio.aws.firehose.model.S3DestinationDescription.ReadOnly
    ] = ZIO.succeed(s3DestinationDescription)
    def getProcessingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.ProcessingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "processingConfiguration",
      processingConfiguration
    )
    def getS3BackupMode
        : ZIO[Any, AwsError, zio.aws.firehose.model.RedshiftS3BackupMode] =
      AwsError.unwrapOptionField("s3BackupMode", s3BackupMode)
    def getS3BackupDescription: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.S3DestinationDescription.ReadOnly
    ] = AwsError.unwrapOptionField("s3BackupDescription", s3BackupDescription)
    def getCloudWatchLoggingOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudWatchLoggingOptions",
      cloudWatchLoggingOptions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.RedshiftDestinationDescription
  ) extends zio.aws.firehose.model.RedshiftDestinationDescription.ReadOnly {
    override val roleARN: RoleARN =
      zio.aws.firehose.model.primitives.RoleARN(impl.roleARN())
    override val clusterJDBCURL: ClusterJDBCURL =
      zio.aws.firehose.model.primitives.ClusterJDBCURL(impl.clusterJDBCURL())
    override val copyCommand: zio.aws.firehose.model.CopyCommand.ReadOnly =
      zio.aws.firehose.model.CopyCommand.wrap(impl.copyCommand())
    override val username: Username =
      zio.aws.firehose.model.primitives.Username(impl.username())
    override val retryOptions
        : Option[zio.aws.firehose.model.RedshiftRetryOptions.ReadOnly] = scala
      .Option(impl.retryOptions())
      .map(value => zio.aws.firehose.model.RedshiftRetryOptions.wrap(value))
    override val s3DestinationDescription
        : zio.aws.firehose.model.S3DestinationDescription.ReadOnly =
      zio.aws.firehose.model.S3DestinationDescription
        .wrap(impl.s3DestinationDescription())
    override val processingConfiguration
        : Option[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly] =
      scala
        .Option(impl.processingConfiguration())
        .map(value =>
          zio.aws.firehose.model.ProcessingConfiguration.wrap(value)
        )
    override val s3BackupMode
        : Option[zio.aws.firehose.model.RedshiftS3BackupMode] = scala
      .Option(impl.s3BackupMode())
      .map(value => zio.aws.firehose.model.RedshiftS3BackupMode.wrap(value))
    override val s3BackupDescription
        : Option[zio.aws.firehose.model.S3DestinationDescription.ReadOnly] =
      scala
        .Option(impl.s3BackupDescription())
        .map(value =>
          zio.aws.firehose.model.S3DestinationDescription.wrap(value)
        )
    override val cloudWatchLoggingOptions
        : Option[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly] =
      scala
        .Option(impl.cloudWatchLoggingOptions())
        .map(value =>
          zio.aws.firehose.model.CloudWatchLoggingOptions.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.RedshiftDestinationDescription
  ): zio.aws.firehose.model.RedshiftDestinationDescription.ReadOnly =
    new Wrapper(impl)
}
