package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.{
  Password,
  Username,
  ClusterJDBCURL,
  RoleARN
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RedshiftDestinationUpdate(
    roleARN: Option[RoleARN] = None,
    clusterJDBCURL: Option[ClusterJDBCURL] = None,
    copyCommand: Option[zio.aws.firehose.model.CopyCommand] = None,
    username: Option[Username] = None,
    password: Option[Password] = None,
    retryOptions: Option[zio.aws.firehose.model.RedshiftRetryOptions] = None,
    s3Update: Option[zio.aws.firehose.model.S3DestinationUpdate] = None,
    processingConfiguration: Option[
      zio.aws.firehose.model.ProcessingConfiguration
    ] = None,
    s3BackupMode: Option[zio.aws.firehose.model.RedshiftS3BackupMode] = None,
    s3BackupUpdate: Option[zio.aws.firehose.model.S3DestinationUpdate] = None,
    cloudWatchLoggingOptions: Option[
      zio.aws.firehose.model.CloudWatchLoggingOptions
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.RedshiftDestinationUpdate = {
    import RedshiftDestinationUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.RedshiftDestinationUpdate
      .builder()
      .optionallyWith(
        roleARN.map(value => RoleARN.unwrap(value): java.lang.String)
      )(_.roleARN)
      .optionallyWith(
        clusterJDBCURL.map(value =>
          ClusterJDBCURL.unwrap(value): java.lang.String
        )
      )(_.clusterJDBCURL)
      .optionallyWith(copyCommand.map(value => value.buildAwsValue()))(
        _.copyCommand
      )
      .optionallyWith(
        username.map(value => Username.unwrap(value): java.lang.String)
      )(_.username)
      .optionallyWith(
        password.map(value => Password.unwrap(value): java.lang.String)
      )(_.password)
      .optionallyWith(retryOptions.map(value => value.buildAwsValue()))(
        _.retryOptions
      )
      .optionallyWith(s3Update.map(value => value.buildAwsValue()))(_.s3Update)
      .optionallyWith(
        processingConfiguration.map(value => value.buildAwsValue())
      )(_.processingConfiguration)
      .optionallyWith(s3BackupMode.map(value => value.unwrap))(_.s3BackupMode)
      .optionallyWith(s3BackupUpdate.map(value => value.buildAwsValue()))(
        _.s3BackupUpdate
      )
      .optionallyWith(
        cloudWatchLoggingOptions.map(value => value.buildAwsValue())
      )(_.cloudWatchLoggingOptions)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.RedshiftDestinationUpdate.ReadOnly =
    zio.aws.firehose.model.RedshiftDestinationUpdate.wrap(buildAwsValue())
}
object RedshiftDestinationUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.RedshiftDestinationUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.RedshiftDestinationUpdate =
      zio.aws.firehose.model.RedshiftDestinationUpdate(
        roleARN.map(value => value),
        clusterJDBCURL.map(value => value),
        copyCommand.map(value => value.asEditable),
        username.map(value => value),
        password.map(value => value),
        retryOptions.map(value => value.asEditable),
        s3Update.map(value => value.asEditable),
        processingConfiguration.map(value => value.asEditable),
        s3BackupMode.map(value => value),
        s3BackupUpdate.map(value => value.asEditable),
        cloudWatchLoggingOptions.map(value => value.asEditable)
      )
    def roleARN: Option[RoleARN]
    def clusterJDBCURL: Option[ClusterJDBCURL]
    def copyCommand: Option[zio.aws.firehose.model.CopyCommand.ReadOnly]
    def username: Option[Username]
    def password: Option[Password]
    def retryOptions
        : Option[zio.aws.firehose.model.RedshiftRetryOptions.ReadOnly]
    def s3Update: Option[zio.aws.firehose.model.S3DestinationUpdate.ReadOnly]
    def processingConfiguration
        : Option[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly]
    def s3BackupMode: Option[zio.aws.firehose.model.RedshiftS3BackupMode]
    def s3BackupUpdate
        : Option[zio.aws.firehose.model.S3DestinationUpdate.ReadOnly]
    def cloudWatchLoggingOptions
        : Option[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly]
    def getRoleARN: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("roleARN", roleARN)
    def getClusterJDBCURL: ZIO[Any, AwsError, ClusterJDBCURL] =
      AwsError.unwrapOptionField("clusterJDBCURL", clusterJDBCURL)
    def getCopyCommand
        : ZIO[Any, AwsError, zio.aws.firehose.model.CopyCommand.ReadOnly] =
      AwsError.unwrapOptionField("copyCommand", copyCommand)
    def getUsername: ZIO[Any, AwsError, Username] =
      AwsError.unwrapOptionField("username", username)
    def getPassword: ZIO[Any, AwsError, Password] =
      AwsError.unwrapOptionField("password", password)
    def getRetryOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.RedshiftRetryOptions.ReadOnly
    ] = AwsError.unwrapOptionField("retryOptions", retryOptions)
    def getS3Update: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.S3DestinationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField("s3Update", s3Update)
    def getProcessingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.ProcessingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "processingConfiguration",
      processingConfiguration
    )
    def getS3BackupMode
        : ZIO[Any, AwsError, zio.aws.firehose.model.RedshiftS3BackupMode] =
      AwsError.unwrapOptionField("s3BackupMode", s3BackupMode)
    def getS3BackupUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.S3DestinationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField("s3BackupUpdate", s3BackupUpdate)
    def getCloudWatchLoggingOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudWatchLoggingOptions",
      cloudWatchLoggingOptions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.RedshiftDestinationUpdate
  ) extends zio.aws.firehose.model.RedshiftDestinationUpdate.ReadOnly {
    override val roleARN: Option[RoleARN] = scala
      .Option(impl.roleARN())
      .map(value => zio.aws.firehose.model.primitives.RoleARN(value))
    override val clusterJDBCURL: Option[ClusterJDBCURL] = scala
      .Option(impl.clusterJDBCURL())
      .map(value => zio.aws.firehose.model.primitives.ClusterJDBCURL(value))
    override val copyCommand
        : Option[zio.aws.firehose.model.CopyCommand.ReadOnly] = scala
      .Option(impl.copyCommand())
      .map(value => zio.aws.firehose.model.CopyCommand.wrap(value))
    override val username: Option[Username] = scala
      .Option(impl.username())
      .map(value => zio.aws.firehose.model.primitives.Username(value))
    override val password: Option[Password] = scala
      .Option(impl.password())
      .map(value => zio.aws.firehose.model.primitives.Password(value))
    override val retryOptions
        : Option[zio.aws.firehose.model.RedshiftRetryOptions.ReadOnly] = scala
      .Option(impl.retryOptions())
      .map(value => zio.aws.firehose.model.RedshiftRetryOptions.wrap(value))
    override val s3Update
        : Option[zio.aws.firehose.model.S3DestinationUpdate.ReadOnly] = scala
      .Option(impl.s3Update())
      .map(value => zio.aws.firehose.model.S3DestinationUpdate.wrap(value))
    override val processingConfiguration
        : Option[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly] =
      scala
        .Option(impl.processingConfiguration())
        .map(value =>
          zio.aws.firehose.model.ProcessingConfiguration.wrap(value)
        )
    override val s3BackupMode
        : Option[zio.aws.firehose.model.RedshiftS3BackupMode] = scala
      .Option(impl.s3BackupMode())
      .map(value => zio.aws.firehose.model.RedshiftS3BackupMode.wrap(value))
    override val s3BackupUpdate
        : Option[zio.aws.firehose.model.S3DestinationUpdate.ReadOnly] = scala
      .Option(impl.s3BackupUpdate())
      .map(value => zio.aws.firehose.model.S3DestinationUpdate.wrap(value))
    override val cloudWatchLoggingOptions
        : Option[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly] =
      scala
        .Option(impl.cloudWatchLoggingOptions())
        .map(value =>
          zio.aws.firehose.model.CloudWatchLoggingOptions.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.RedshiftDestinationUpdate
  ): zio.aws.firehose.model.RedshiftDestinationUpdate.ReadOnly = new Wrapper(
    impl
  )
}
