package zio.aws.firehose.model
import java.lang.Integer
import zio.aws.firehose.model.primitives.RedshiftRetryDurationInSeconds
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RedshiftRetryOptions(
    durationInSeconds: Option[RedshiftRetryDurationInSeconds] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.RedshiftRetryOptions = {
    import RedshiftRetryOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.RedshiftRetryOptions
      .builder()
      .optionallyWith(
        durationInSeconds.map(value =>
          RedshiftRetryDurationInSeconds.unwrap(value): Integer
        )
      )(_.durationInSeconds)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.RedshiftRetryOptions.ReadOnly =
    zio.aws.firehose.model.RedshiftRetryOptions.wrap(buildAwsValue())
}
object RedshiftRetryOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.RedshiftRetryOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.RedshiftRetryOptions =
      zio.aws.firehose.model
        .RedshiftRetryOptions(durationInSeconds.map(value => value))
    def durationInSeconds: Option[RedshiftRetryDurationInSeconds]
    def getDurationInSeconds
        : ZIO[Any, AwsError, RedshiftRetryDurationInSeconds] =
      AwsError.unwrapOptionField("durationInSeconds", durationInSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.RedshiftRetryOptions
  ) extends zio.aws.firehose.model.RedshiftRetryOptions.ReadOnly {
    override val durationInSeconds: Option[RedshiftRetryDurationInSeconds] =
      scala
        .Option(impl.durationInSeconds())
        .map(value =>
          zio.aws.firehose.model.primitives
            .RedshiftRetryDurationInSeconds(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.RedshiftRetryOptions
  ): zio.aws.firehose.model.RedshiftRetryOptions.ReadOnly = new Wrapper(impl)
}
