package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.{
  ErrorOutputPrefix,
  Prefix,
  BucketARN,
  RoleARN
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class S3DestinationConfiguration(
    roleARN: RoleARN,
    bucketARN: BucketARN,
    prefix: Option[Prefix] = None,
    errorOutputPrefix: Option[ErrorOutputPrefix] = None,
    bufferingHints: Option[zio.aws.firehose.model.BufferingHints] = None,
    compressionFormat: Option[zio.aws.firehose.model.CompressionFormat] = None,
    encryptionConfiguration: Option[
      zio.aws.firehose.model.EncryptionConfiguration
    ] = None,
    cloudWatchLoggingOptions: Option[
      zio.aws.firehose.model.CloudWatchLoggingOptions
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.S3DestinationConfiguration = {
    import S3DestinationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.S3DestinationConfiguration
      .builder()
      .roleARN(RoleARN.unwrap(roleARN): java.lang.String)
      .bucketARN(BucketARN.unwrap(bucketARN): java.lang.String)
      .optionallyWith(
        prefix.map(value => Prefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(
        errorOutputPrefix.map(value =>
          ErrorOutputPrefix.unwrap(value): java.lang.String
        )
      )(_.errorOutputPrefix)
      .optionallyWith(bufferingHints.map(value => value.buildAwsValue()))(
        _.bufferingHints
      )
      .optionallyWith(compressionFormat.map(value => value.unwrap))(
        _.compressionFormat
      )
      .optionallyWith(
        encryptionConfiguration.map(value => value.buildAwsValue())
      )(_.encryptionConfiguration)
      .optionallyWith(
        cloudWatchLoggingOptions.map(value => value.buildAwsValue())
      )(_.cloudWatchLoggingOptions)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.S3DestinationConfiguration.ReadOnly =
    zio.aws.firehose.model.S3DestinationConfiguration.wrap(buildAwsValue())
}
object S3DestinationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.S3DestinationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.S3DestinationConfiguration =
      zio.aws.firehose.model.S3DestinationConfiguration(
        roleARN,
        bucketARN,
        prefix.map(value => value),
        errorOutputPrefix.map(value => value),
        bufferingHints.map(value => value.asEditable),
        compressionFormat.map(value => value),
        encryptionConfiguration.map(value => value.asEditable),
        cloudWatchLoggingOptions.map(value => value.asEditable)
      )
    def roleARN: RoleARN
    def bucketARN: BucketARN
    def prefix: Option[Prefix]
    def errorOutputPrefix: Option[ErrorOutputPrefix]
    def bufferingHints: Option[zio.aws.firehose.model.BufferingHints.ReadOnly]
    def compressionFormat: Option[zio.aws.firehose.model.CompressionFormat]
    def encryptionConfiguration
        : Option[zio.aws.firehose.model.EncryptionConfiguration.ReadOnly]
    def cloudWatchLoggingOptions
        : Option[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly]
    def getRoleARN: ZIO[Any, Nothing, RoleARN] = ZIO.succeed(roleARN)
    def getBucketARN: ZIO[Any, Nothing, BucketARN] = ZIO.succeed(bucketARN)
    def getPrefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getErrorOutputPrefix: ZIO[Any, AwsError, ErrorOutputPrefix] =
      AwsError.unwrapOptionField("errorOutputPrefix", errorOutputPrefix)
    def getBufferingHints
        : ZIO[Any, AwsError, zio.aws.firehose.model.BufferingHints.ReadOnly] =
      AwsError.unwrapOptionField("bufferingHints", bufferingHints)
    def getCompressionFormat
        : ZIO[Any, AwsError, zio.aws.firehose.model.CompressionFormat] =
      AwsError.unwrapOptionField("compressionFormat", compressionFormat)
    def getEncryptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.EncryptionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionConfiguration",
      encryptionConfiguration
    )
    def getCloudWatchLoggingOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudWatchLoggingOptions",
      cloudWatchLoggingOptions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.S3DestinationConfiguration
  ) extends zio.aws.firehose.model.S3DestinationConfiguration.ReadOnly {
    override val roleARN: RoleARN =
      zio.aws.firehose.model.primitives.RoleARN(impl.roleARN())
    override val bucketARN: BucketARN =
      zio.aws.firehose.model.primitives.BucketARN(impl.bucketARN())
    override val prefix: Option[Prefix] = scala
      .Option(impl.prefix())
      .map(value => zio.aws.firehose.model.primitives.Prefix(value))
    override val errorOutputPrefix: Option[ErrorOutputPrefix] = scala
      .Option(impl.errorOutputPrefix())
      .map(value => zio.aws.firehose.model.primitives.ErrorOutputPrefix(value))
    override val bufferingHints
        : Option[zio.aws.firehose.model.BufferingHints.ReadOnly] = scala
      .Option(impl.bufferingHints())
      .map(value => zio.aws.firehose.model.BufferingHints.wrap(value))
    override val compressionFormat
        : Option[zio.aws.firehose.model.CompressionFormat] = scala
      .Option(impl.compressionFormat())
      .map(value => zio.aws.firehose.model.CompressionFormat.wrap(value))
    override val encryptionConfiguration
        : Option[zio.aws.firehose.model.EncryptionConfiguration.ReadOnly] =
      scala
        .Option(impl.encryptionConfiguration())
        .map(value =>
          zio.aws.firehose.model.EncryptionConfiguration.wrap(value)
        )
    override val cloudWatchLoggingOptions
        : Option[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly] =
      scala
        .Option(impl.cloudWatchLoggingOptions())
        .map(value =>
          zio.aws.firehose.model.CloudWatchLoggingOptions.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.S3DestinationConfiguration
  ): zio.aws.firehose.model.S3DestinationConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
