package zio.aws.firehose.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Serializer(
    parquetSerDe: Option[zio.aws.firehose.model.ParquetSerDe] = None,
    orcSerDe: Option[zio.aws.firehose.model.OrcSerDe] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.Serializer = {
    import Serializer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.Serializer
      .builder()
      .optionallyWith(parquetSerDe.map(value => value.buildAwsValue()))(
        _.parquetSerDe
      )
      .optionallyWith(orcSerDe.map(value => value.buildAwsValue()))(_.orcSerDe)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.Serializer.ReadOnly =
    zio.aws.firehose.model.Serializer.wrap(buildAwsValue())
}
object Serializer {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.Serializer
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.Serializer =
      zio.aws.firehose.model.Serializer(
        parquetSerDe.map(value => value.asEditable),
        orcSerDe.map(value => value.asEditable)
      )
    def parquetSerDe: Option[zio.aws.firehose.model.ParquetSerDe.ReadOnly]
    def orcSerDe: Option[zio.aws.firehose.model.OrcSerDe.ReadOnly]
    def getParquetSerDe
        : ZIO[Any, AwsError, zio.aws.firehose.model.ParquetSerDe.ReadOnly] =
      AwsError.unwrapOptionField("parquetSerDe", parquetSerDe)
    def getOrcSerDe
        : ZIO[Any, AwsError, zio.aws.firehose.model.OrcSerDe.ReadOnly] =
      AwsError.unwrapOptionField("orcSerDe", orcSerDe)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.Serializer
  ) extends zio.aws.firehose.model.Serializer.ReadOnly {
    override val parquetSerDe
        : Option[zio.aws.firehose.model.ParquetSerDe.ReadOnly] = scala
      .Option(impl.parquetSerDe())
      .map(value => zio.aws.firehose.model.ParquetSerDe.wrap(value))
    override val orcSerDe: Option[zio.aws.firehose.model.OrcSerDe.ReadOnly] =
      scala
        .Option(impl.orcSerDe())
        .map(value => zio.aws.firehose.model.OrcSerDe.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.Serializer
  ): zio.aws.firehose.model.Serializer.ReadOnly = new Wrapper(impl)
}
