package zio.aws.firehose.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SourceDescription(
    kinesisStreamSourceDescription: Option[
      zio.aws.firehose.model.KinesisStreamSourceDescription
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.SourceDescription = {
    import SourceDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.SourceDescription
      .builder()
      .optionallyWith(
        kinesisStreamSourceDescription.map(value => value.buildAwsValue())
      )(_.kinesisStreamSourceDescription)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.SourceDescription.ReadOnly =
    zio.aws.firehose.model.SourceDescription.wrap(buildAwsValue())
}
object SourceDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.SourceDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.SourceDescription =
      zio.aws.firehose.model.SourceDescription(
        kinesisStreamSourceDescription.map(value => value.asEditable)
      )
    def kinesisStreamSourceDescription
        : Option[zio.aws.firehose.model.KinesisStreamSourceDescription.ReadOnly]
    def getKinesisStreamSourceDescription: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.KinesisStreamSourceDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kinesisStreamSourceDescription",
      kinesisStreamSourceDescription
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.SourceDescription
  ) extends zio.aws.firehose.model.SourceDescription.ReadOnly {
    override val kinesisStreamSourceDescription: Option[
      zio.aws.firehose.model.KinesisStreamSourceDescription.ReadOnly
    ] = scala
      .Option(impl.kinesisStreamSourceDescription())
      .map(value =>
        zio.aws.firehose.model.KinesisStreamSourceDescription.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.SourceDescription
  ): zio.aws.firehose.model.SourceDescription.ReadOnly = new Wrapper(impl)
}
