package zio.aws.firehose.model
import java.lang.Integer
import zio.aws.firehose.model.primitives.{
  HECAcknowledgmentTimeoutInSeconds,
  HECToken,
  HECEndpoint
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SplunkDestinationUpdate(
    hecEndpoint: Option[HECEndpoint] = None,
    hecEndpointType: Option[zio.aws.firehose.model.HECEndpointType] = None,
    hecToken: Option[HECToken] = None,
    hecAcknowledgmentTimeoutInSeconds: Option[
      HECAcknowledgmentTimeoutInSeconds
    ] = None,
    retryOptions: Option[zio.aws.firehose.model.SplunkRetryOptions] = None,
    s3BackupMode: Option[zio.aws.firehose.model.SplunkS3BackupMode] = None,
    s3Update: Option[zio.aws.firehose.model.S3DestinationUpdate] = None,
    processingConfiguration: Option[
      zio.aws.firehose.model.ProcessingConfiguration
    ] = None,
    cloudWatchLoggingOptions: Option[
      zio.aws.firehose.model.CloudWatchLoggingOptions
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.SplunkDestinationUpdate = {
    import SplunkDestinationUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.SplunkDestinationUpdate
      .builder()
      .optionallyWith(
        hecEndpoint.map(value => HECEndpoint.unwrap(value): java.lang.String)
      )(_.hecEndpoint)
      .optionallyWith(hecEndpointType.map(value => value.unwrap))(
        _.hecEndpointType
      )
      .optionallyWith(
        hecToken.map(value => HECToken.unwrap(value): java.lang.String)
      )(_.hecToken)
      .optionallyWith(
        hecAcknowledgmentTimeoutInSeconds.map(value =>
          HECAcknowledgmentTimeoutInSeconds.unwrap(value): Integer
        )
      )(_.hecAcknowledgmentTimeoutInSeconds)
      .optionallyWith(retryOptions.map(value => value.buildAwsValue()))(
        _.retryOptions
      )
      .optionallyWith(s3BackupMode.map(value => value.unwrap))(_.s3BackupMode)
      .optionallyWith(s3Update.map(value => value.buildAwsValue()))(_.s3Update)
      .optionallyWith(
        processingConfiguration.map(value => value.buildAwsValue())
      )(_.processingConfiguration)
      .optionallyWith(
        cloudWatchLoggingOptions.map(value => value.buildAwsValue())
      )(_.cloudWatchLoggingOptions)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.SplunkDestinationUpdate.ReadOnly =
    zio.aws.firehose.model.SplunkDestinationUpdate.wrap(buildAwsValue())
}
object SplunkDestinationUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.SplunkDestinationUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.SplunkDestinationUpdate =
      zio.aws.firehose.model.SplunkDestinationUpdate(
        hecEndpoint.map(value => value),
        hecEndpointType.map(value => value),
        hecToken.map(value => value),
        hecAcknowledgmentTimeoutInSeconds.map(value => value),
        retryOptions.map(value => value.asEditable),
        s3BackupMode.map(value => value),
        s3Update.map(value => value.asEditable),
        processingConfiguration.map(value => value.asEditable),
        cloudWatchLoggingOptions.map(value => value.asEditable)
      )
    def hecEndpoint: Option[HECEndpoint]
    def hecEndpointType: Option[zio.aws.firehose.model.HECEndpointType]
    def hecToken: Option[HECToken]
    def hecAcknowledgmentTimeoutInSeconds
        : Option[HECAcknowledgmentTimeoutInSeconds]
    def retryOptions: Option[zio.aws.firehose.model.SplunkRetryOptions.ReadOnly]
    def s3BackupMode: Option[zio.aws.firehose.model.SplunkS3BackupMode]
    def s3Update: Option[zio.aws.firehose.model.S3DestinationUpdate.ReadOnly]
    def processingConfiguration
        : Option[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly]
    def cloudWatchLoggingOptions
        : Option[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly]
    def getHecEndpoint: ZIO[Any, AwsError, HECEndpoint] =
      AwsError.unwrapOptionField("hecEndpoint", hecEndpoint)
    def getHecEndpointType
        : ZIO[Any, AwsError, zio.aws.firehose.model.HECEndpointType] =
      AwsError.unwrapOptionField("hecEndpointType", hecEndpointType)
    def getHecToken: ZIO[Any, AwsError, HECToken] =
      AwsError.unwrapOptionField("hecToken", hecToken)
    def getHecAcknowledgmentTimeoutInSeconds
        : ZIO[Any, AwsError, HECAcknowledgmentTimeoutInSeconds] =
      AwsError.unwrapOptionField(
        "hecAcknowledgmentTimeoutInSeconds",
        hecAcknowledgmentTimeoutInSeconds
      )
    def getRetryOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.SplunkRetryOptions.ReadOnly
    ] = AwsError.unwrapOptionField("retryOptions", retryOptions)
    def getS3BackupMode
        : ZIO[Any, AwsError, zio.aws.firehose.model.SplunkS3BackupMode] =
      AwsError.unwrapOptionField("s3BackupMode", s3BackupMode)
    def getS3Update: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.S3DestinationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField("s3Update", s3Update)
    def getProcessingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.ProcessingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "processingConfiguration",
      processingConfiguration
    )
    def getCloudWatchLoggingOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudWatchLoggingOptions",
      cloudWatchLoggingOptions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.SplunkDestinationUpdate
  ) extends zio.aws.firehose.model.SplunkDestinationUpdate.ReadOnly {
    override val hecEndpoint: Option[HECEndpoint] = scala
      .Option(impl.hecEndpoint())
      .map(value => zio.aws.firehose.model.primitives.HECEndpoint(value))
    override val hecEndpointType
        : Option[zio.aws.firehose.model.HECEndpointType] = scala
      .Option(impl.hecEndpointType())
      .map(value => zio.aws.firehose.model.HECEndpointType.wrap(value))
    override val hecToken: Option[HECToken] = scala
      .Option(impl.hecToken())
      .map(value => zio.aws.firehose.model.primitives.HECToken(value))
    override val hecAcknowledgmentTimeoutInSeconds
        : Option[HECAcknowledgmentTimeoutInSeconds] = scala
      .Option(impl.hecAcknowledgmentTimeoutInSeconds())
      .map(value =>
        zio.aws.firehose.model.primitives
          .HECAcknowledgmentTimeoutInSeconds(value)
      )
    override val retryOptions
        : Option[zio.aws.firehose.model.SplunkRetryOptions.ReadOnly] = scala
      .Option(impl.retryOptions())
      .map(value => zio.aws.firehose.model.SplunkRetryOptions.wrap(value))
    override val s3BackupMode
        : Option[zio.aws.firehose.model.SplunkS3BackupMode] = scala
      .Option(impl.s3BackupMode())
      .map(value => zio.aws.firehose.model.SplunkS3BackupMode.wrap(value))
    override val s3Update
        : Option[zio.aws.firehose.model.S3DestinationUpdate.ReadOnly] = scala
      .Option(impl.s3Update())
      .map(value => zio.aws.firehose.model.S3DestinationUpdate.wrap(value))
    override val processingConfiguration
        : Option[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly] =
      scala
        .Option(impl.processingConfiguration())
        .map(value =>
          zio.aws.firehose.model.ProcessingConfiguration.wrap(value)
        )
    override val cloudWatchLoggingOptions
        : Option[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly] =
      scala
        .Option(impl.cloudWatchLoggingOptions())
        .map(value =>
          zio.aws.firehose.model.CloudWatchLoggingOptions.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.SplunkDestinationUpdate
  ): zio.aws.firehose.model.SplunkDestinationUpdate.ReadOnly = new Wrapper(impl)
}
