package zio.aws.firehose.model
import java.lang.Integer
import zio.aws.firehose.model.primitives.SplunkRetryDurationInSeconds
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SplunkRetryOptions(
    durationInSeconds: Option[SplunkRetryDurationInSeconds] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.SplunkRetryOptions = {
    import SplunkRetryOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.SplunkRetryOptions
      .builder()
      .optionallyWith(
        durationInSeconds.map(value =>
          SplunkRetryDurationInSeconds.unwrap(value): Integer
        )
      )(_.durationInSeconds)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.SplunkRetryOptions.ReadOnly =
    zio.aws.firehose.model.SplunkRetryOptions.wrap(buildAwsValue())
}
object SplunkRetryOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.SplunkRetryOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.SplunkRetryOptions =
      zio.aws.firehose.model
        .SplunkRetryOptions(durationInSeconds.map(value => value))
    def durationInSeconds: Option[SplunkRetryDurationInSeconds]
    def getDurationInSeconds: ZIO[Any, AwsError, SplunkRetryDurationInSeconds] =
      AwsError.unwrapOptionField("durationInSeconds", durationInSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.SplunkRetryOptions
  ) extends zio.aws.firehose.model.SplunkRetryOptions.ReadOnly {
    override val durationInSeconds: Option[SplunkRetryDurationInSeconds] = scala
      .Option(impl.durationInSeconds())
      .map(value =>
        zio.aws.firehose.model.primitives.SplunkRetryDurationInSeconds(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.SplunkRetryOptions
  ): zio.aws.firehose.model.SplunkRetryOptions.ReadOnly = new Wrapper(impl)
}
