package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.DeliveryStreamName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StartDeliveryStreamEncryptionRequest(
    deliveryStreamName: DeliveryStreamName,
    deliveryStreamEncryptionConfigurationInput: Option[
      zio.aws.firehose.model.DeliveryStreamEncryptionConfigurationInput
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.StartDeliveryStreamEncryptionRequest = {
    import StartDeliveryStreamEncryptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.StartDeliveryStreamEncryptionRequest
      .builder()
      .deliveryStreamName(
        DeliveryStreamName.unwrap(deliveryStreamName): java.lang.String
      )
      .optionallyWith(
        deliveryStreamEncryptionConfigurationInput.map(value =>
          value.buildAwsValue()
        )
      )(_.deliveryStreamEncryptionConfigurationInput)
      .build()
  }
  def asReadOnly
      : zio.aws.firehose.model.StartDeliveryStreamEncryptionRequest.ReadOnly =
    zio.aws.firehose.model.StartDeliveryStreamEncryptionRequest
      .wrap(buildAwsValue())
}
object StartDeliveryStreamEncryptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.StartDeliveryStreamEncryptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.firehose.model.StartDeliveryStreamEncryptionRequest =
      zio.aws.firehose.model.StartDeliveryStreamEncryptionRequest(
        deliveryStreamName,
        deliveryStreamEncryptionConfigurationInput.map(value =>
          value.asEditable
        )
      )
    def deliveryStreamName: DeliveryStreamName
    def deliveryStreamEncryptionConfigurationInput: Option[
      zio.aws.firehose.model.DeliveryStreamEncryptionConfigurationInput.ReadOnly
    ]
    def getDeliveryStreamName: ZIO[Any, Nothing, DeliveryStreamName] =
      ZIO.succeed(deliveryStreamName)
    def getDeliveryStreamEncryptionConfigurationInput: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.DeliveryStreamEncryptionConfigurationInput.ReadOnly
    ] = AwsError.unwrapOptionField(
      "deliveryStreamEncryptionConfigurationInput",
      deliveryStreamEncryptionConfigurationInput
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.StartDeliveryStreamEncryptionRequest
  ) extends zio.aws.firehose.model.StartDeliveryStreamEncryptionRequest.ReadOnly {
    override val deliveryStreamName: DeliveryStreamName =
      zio.aws.firehose.model.primitives
        .DeliveryStreamName(impl.deliveryStreamName())
    override val deliveryStreamEncryptionConfigurationInput: Option[
      zio.aws.firehose.model.DeliveryStreamEncryptionConfigurationInput.ReadOnly
    ] = scala
      .Option(impl.deliveryStreamEncryptionConfigurationInput())
      .map(value =>
        zio.aws.firehose.model.DeliveryStreamEncryptionConfigurationInput
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.StartDeliveryStreamEncryptionRequest
  ): zio.aws.firehose.model.StartDeliveryStreamEncryptionRequest.ReadOnly =
    new Wrapper(impl)
}
