package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.{
  DestinationId,
  DeliveryStreamVersionId,
  DeliveryStreamName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateDestinationRequest(
    deliveryStreamName: DeliveryStreamName,
    currentDeliveryStreamVersionId: DeliveryStreamVersionId,
    destinationId: DestinationId,
    s3DestinationUpdate: Option[zio.aws.firehose.model.S3DestinationUpdate] =
      None,
    extendedS3DestinationUpdate: Option[
      zio.aws.firehose.model.ExtendedS3DestinationUpdate
    ] = None,
    redshiftDestinationUpdate: Option[
      zio.aws.firehose.model.RedshiftDestinationUpdate
    ] = None,
    elasticsearchDestinationUpdate: Option[
      zio.aws.firehose.model.ElasticsearchDestinationUpdate
    ] = None,
    amazonopensearchserviceDestinationUpdate: Option[
      zio.aws.firehose.model.AmazonopensearchserviceDestinationUpdate
    ] = None,
    splunkDestinationUpdate: Option[
      zio.aws.firehose.model.SplunkDestinationUpdate
    ] = None,
    httpEndpointDestinationUpdate: Option[
      zio.aws.firehose.model.HttpEndpointDestinationUpdate
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.UpdateDestinationRequest = {
    import UpdateDestinationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.UpdateDestinationRequest
      .builder()
      .deliveryStreamName(
        DeliveryStreamName.unwrap(deliveryStreamName): java.lang.String
      )
      .currentDeliveryStreamVersionId(
        DeliveryStreamVersionId.unwrap(
          currentDeliveryStreamVersionId
        ): java.lang.String
      )
      .destinationId(DestinationId.unwrap(destinationId): java.lang.String)
      .optionallyWith(s3DestinationUpdate.map(value => value.buildAwsValue()))(
        _.s3DestinationUpdate
      )
      .optionallyWith(
        extendedS3DestinationUpdate.map(value => value.buildAwsValue())
      )(_.extendedS3DestinationUpdate)
      .optionallyWith(
        redshiftDestinationUpdate.map(value => value.buildAwsValue())
      )(_.redshiftDestinationUpdate)
      .optionallyWith(
        elasticsearchDestinationUpdate.map(value => value.buildAwsValue())
      )(_.elasticsearchDestinationUpdate)
      .optionallyWith(
        amazonopensearchserviceDestinationUpdate.map(value =>
          value.buildAwsValue()
        )
      )(_.amazonopensearchserviceDestinationUpdate)
      .optionallyWith(
        splunkDestinationUpdate.map(value => value.buildAwsValue())
      )(_.splunkDestinationUpdate)
      .optionallyWith(
        httpEndpointDestinationUpdate.map(value => value.buildAwsValue())
      )(_.httpEndpointDestinationUpdate)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.UpdateDestinationRequest.ReadOnly =
    zio.aws.firehose.model.UpdateDestinationRequest.wrap(buildAwsValue())
}
object UpdateDestinationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.UpdateDestinationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.UpdateDestinationRequest =
      zio.aws.firehose.model.UpdateDestinationRequest(
        deliveryStreamName,
        currentDeliveryStreamVersionId,
        destinationId,
        s3DestinationUpdate.map(value => value.asEditable),
        extendedS3DestinationUpdate.map(value => value.asEditable),
        redshiftDestinationUpdate.map(value => value.asEditable),
        elasticsearchDestinationUpdate.map(value => value.asEditable),
        amazonopensearchserviceDestinationUpdate.map(value => value.asEditable),
        splunkDestinationUpdate.map(value => value.asEditable),
        httpEndpointDestinationUpdate.map(value => value.asEditable)
      )
    def deliveryStreamName: DeliveryStreamName
    def currentDeliveryStreamVersionId: DeliveryStreamVersionId
    def destinationId: DestinationId
    def s3DestinationUpdate
        : Option[zio.aws.firehose.model.S3DestinationUpdate.ReadOnly]
    def extendedS3DestinationUpdate
        : Option[zio.aws.firehose.model.ExtendedS3DestinationUpdate.ReadOnly]
    def redshiftDestinationUpdate
        : Option[zio.aws.firehose.model.RedshiftDestinationUpdate.ReadOnly]
    def elasticsearchDestinationUpdate
        : Option[zio.aws.firehose.model.ElasticsearchDestinationUpdate.ReadOnly]
    def amazonopensearchserviceDestinationUpdate: Option[
      zio.aws.firehose.model.AmazonopensearchserviceDestinationUpdate.ReadOnly
    ]
    def splunkDestinationUpdate
        : Option[zio.aws.firehose.model.SplunkDestinationUpdate.ReadOnly]
    def httpEndpointDestinationUpdate
        : Option[zio.aws.firehose.model.HttpEndpointDestinationUpdate.ReadOnly]
    def getDeliveryStreamName: ZIO[Any, Nothing, DeliveryStreamName] =
      ZIO.succeed(deliveryStreamName)
    def getCurrentDeliveryStreamVersionId
        : ZIO[Any, Nothing, DeliveryStreamVersionId] =
      ZIO.succeed(currentDeliveryStreamVersionId)
    def getDestinationId: ZIO[Any, Nothing, DestinationId] =
      ZIO.succeed(destinationId)
    def getS3DestinationUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.S3DestinationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField("s3DestinationUpdate", s3DestinationUpdate)
    def getExtendedS3DestinationUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.ExtendedS3DestinationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "extendedS3DestinationUpdate",
      extendedS3DestinationUpdate
    )
    def getRedshiftDestinationUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.RedshiftDestinationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "redshiftDestinationUpdate",
      redshiftDestinationUpdate
    )
    def getElasticsearchDestinationUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.ElasticsearchDestinationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "elasticsearchDestinationUpdate",
      elasticsearchDestinationUpdate
    )
    def getAmazonopensearchserviceDestinationUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.AmazonopensearchserviceDestinationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "amazonopensearchserviceDestinationUpdate",
      amazonopensearchserviceDestinationUpdate
    )
    def getSplunkDestinationUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.SplunkDestinationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "splunkDestinationUpdate",
      splunkDestinationUpdate
    )
    def getHttpEndpointDestinationUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.HttpEndpointDestinationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "httpEndpointDestinationUpdate",
      httpEndpointDestinationUpdate
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.UpdateDestinationRequest
  ) extends zio.aws.firehose.model.UpdateDestinationRequest.ReadOnly {
    override val deliveryStreamName: DeliveryStreamName =
      zio.aws.firehose.model.primitives
        .DeliveryStreamName(impl.deliveryStreamName())
    override val currentDeliveryStreamVersionId: DeliveryStreamVersionId =
      zio.aws.firehose.model.primitives
        .DeliveryStreamVersionId(impl.currentDeliveryStreamVersionId())
    override val destinationId: DestinationId =
      zio.aws.firehose.model.primitives.DestinationId(impl.destinationId())
    override val s3DestinationUpdate
        : Option[zio.aws.firehose.model.S3DestinationUpdate.ReadOnly] = scala
      .Option(impl.s3DestinationUpdate())
      .map(value => zio.aws.firehose.model.S3DestinationUpdate.wrap(value))
    override val extendedS3DestinationUpdate
        : Option[zio.aws.firehose.model.ExtendedS3DestinationUpdate.ReadOnly] =
      scala
        .Option(impl.extendedS3DestinationUpdate())
        .map(value =>
          zio.aws.firehose.model.ExtendedS3DestinationUpdate.wrap(value)
        )
    override val redshiftDestinationUpdate
        : Option[zio.aws.firehose.model.RedshiftDestinationUpdate.ReadOnly] =
      scala
        .Option(impl.redshiftDestinationUpdate())
        .map(value =>
          zio.aws.firehose.model.RedshiftDestinationUpdate.wrap(value)
        )
    override val elasticsearchDestinationUpdate: Option[
      zio.aws.firehose.model.ElasticsearchDestinationUpdate.ReadOnly
    ] = scala
      .Option(impl.elasticsearchDestinationUpdate())
      .map(value =>
        zio.aws.firehose.model.ElasticsearchDestinationUpdate.wrap(value)
      )
    override val amazonopensearchserviceDestinationUpdate: Option[
      zio.aws.firehose.model.AmazonopensearchserviceDestinationUpdate.ReadOnly
    ] = scala
      .Option(impl.amazonopensearchserviceDestinationUpdate())
      .map(value =>
        zio.aws.firehose.model.AmazonopensearchserviceDestinationUpdate
          .wrap(value)
      )
    override val splunkDestinationUpdate
        : Option[zio.aws.firehose.model.SplunkDestinationUpdate.ReadOnly] =
      scala
        .Option(impl.splunkDestinationUpdate())
        .map(value =>
          zio.aws.firehose.model.SplunkDestinationUpdate.wrap(value)
        )
    override val httpEndpointDestinationUpdate: Option[
      zio.aws.firehose.model.HttpEndpointDestinationUpdate.ReadOnly
    ] = scala
      .Option(impl.httpEndpointDestinationUpdate())
      .map(value =>
        zio.aws.firehose.model.HttpEndpointDestinationUpdate.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.UpdateDestinationRequest
  ): zio.aws.firehose.model.UpdateDestinationRequest.ReadOnly = new Wrapper(
    impl
  )
}
