package zio.aws.firehose
import zio.aws.firehose.model.primitives.HttpEndpointName.Type
import java.time.Instant
import zio.Chunk
import zio.prelude.Subtype
import zio.aws.firehose.model.primitives.{
  TagKey,
  DeliveryStreamName,
  NonEmptyString,
  NonEmptyStringWithoutWhitespace
}
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object AWSKMSKeyARN extends Subtype[String]
    type AWSKMSKeyARN = zio.aws.firehose.model.primitives.AWSKMSKeyARN.Type
    object AmazonopensearchserviceBufferingIntervalInSeconds
        extends Subtype[Int]
    type AmazonopensearchserviceBufferingIntervalInSeconds =
      zio.aws.firehose.model.primitives.AmazonopensearchserviceBufferingIntervalInSeconds.Type
    object AmazonopensearchserviceBufferingSizeInMBs extends Subtype[Int]
    type AmazonopensearchserviceBufferingSizeInMBs =
      zio.aws.firehose.model.primitives.AmazonopensearchserviceBufferingSizeInMBs.Type
    object AmazonopensearchserviceClusterEndpoint extends Subtype[String]
    type AmazonopensearchserviceClusterEndpoint =
      zio.aws.firehose.model.primitives.AmazonopensearchserviceClusterEndpoint.Type
    object AmazonopensearchserviceDomainARN extends Subtype[String]
    type AmazonopensearchserviceDomainARN =
      zio.aws.firehose.model.primitives.AmazonopensearchserviceDomainARN.Type
    object AmazonopensearchserviceIndexName extends Subtype[String]
    type AmazonopensearchserviceIndexName =
      zio.aws.firehose.model.primitives.AmazonopensearchserviceIndexName.Type
    object AmazonopensearchserviceRetryDurationInSeconds extends Subtype[Int]
    type AmazonopensearchserviceRetryDurationInSeconds =
      zio.aws.firehose.model.primitives.AmazonopensearchserviceRetryDurationInSeconds.Type
    object AmazonopensearchserviceTypeName extends Subtype[String]
    type AmazonopensearchserviceTypeName =
      zio.aws.firehose.model.primitives.AmazonopensearchserviceTypeName.Type
    object BlockSizeBytes extends Subtype[Int]
    type BlockSizeBytes = zio.aws.firehose.model.primitives.BlockSizeBytes.Type
    object BooleanObject extends Subtype[Boolean]
    type BooleanObject = zio.aws.firehose.model.primitives.BooleanObject.Type
    object BucketARN extends Subtype[String]
    type BucketARN = zio.aws.firehose.model.primitives.BucketARN.Type
    object ClusterJDBCURL extends Subtype[String]
    type ClusterJDBCURL = zio.aws.firehose.model.primitives.ClusterJDBCURL.Type
    object CopyOptions extends Subtype[String]
    type CopyOptions = zio.aws.firehose.model.primitives.CopyOptions.Type
    object Data extends Subtype[Chunk[Byte]]
    type Data = zio.aws.firehose.model.primitives.Data.Type
    object DataTableColumns extends Subtype[String]
    type DataTableColumns =
      zio.aws.firehose.model.primitives.DataTableColumns.Type
    object DataTableName extends Subtype[String]
    type DataTableName = zio.aws.firehose.model.primitives.DataTableName.Type
    object DeliveryStartTimestamp extends Subtype[Instant]
    type DeliveryStartTimestamp =
      zio.aws.firehose.model.primitives.DeliveryStartTimestamp.Type
    object DeliveryStreamARN extends Subtype[String]
    type DeliveryStreamARN =
      zio.aws.firehose.model.primitives.DeliveryStreamARN.Type
    object DeliveryStreamName extends Subtype[String]
    type DeliveryStreamName =
      zio.aws.firehose.model.primitives.DeliveryStreamName.Type
    object DeliveryStreamVersionId extends Subtype[String]
    type DeliveryStreamVersionId =
      zio.aws.firehose.model.primitives.DeliveryStreamVersionId.Type
    object DescribeDeliveryStreamInputLimit extends Subtype[Int]
    type DescribeDeliveryStreamInputLimit =
      zio.aws.firehose.model.primitives.DescribeDeliveryStreamInputLimit.Type
    object DestinationId extends Subtype[String]
    type DestinationId = zio.aws.firehose.model.primitives.DestinationId.Type
    object ElasticsearchBufferingIntervalInSeconds extends Subtype[Int]
    type ElasticsearchBufferingIntervalInSeconds =
      zio.aws.firehose.model.primitives.ElasticsearchBufferingIntervalInSeconds.Type
    object ElasticsearchBufferingSizeInMBs extends Subtype[Int]
    type ElasticsearchBufferingSizeInMBs =
      zio.aws.firehose.model.primitives.ElasticsearchBufferingSizeInMBs.Type
    object ElasticsearchClusterEndpoint extends Subtype[String]
    type ElasticsearchClusterEndpoint =
      zio.aws.firehose.model.primitives.ElasticsearchClusterEndpoint.Type
    object ElasticsearchDomainARN extends Subtype[String]
    type ElasticsearchDomainARN =
      zio.aws.firehose.model.primitives.ElasticsearchDomainARN.Type
    object ElasticsearchIndexName extends Subtype[String]
    type ElasticsearchIndexName =
      zio.aws.firehose.model.primitives.ElasticsearchIndexName.Type
    object ElasticsearchRetryDurationInSeconds extends Subtype[Int]
    type ElasticsearchRetryDurationInSeconds =
      zio.aws.firehose.model.primitives.ElasticsearchRetryDurationInSeconds.Type
    object ElasticsearchTypeName extends Subtype[String]
    type ElasticsearchTypeName =
      zio.aws.firehose.model.primitives.ElasticsearchTypeName.Type
    object ErrorCode extends Subtype[String]
    type ErrorCode = zio.aws.firehose.model.primitives.ErrorCode.Type
    object ErrorMessage extends Subtype[String]
    type ErrorMessage = zio.aws.firehose.model.primitives.ErrorMessage.Type
    object ErrorOutputPrefix extends Subtype[String]
    type ErrorOutputPrefix =
      zio.aws.firehose.model.primitives.ErrorOutputPrefix.Type
    object HECAcknowledgmentTimeoutInSeconds extends Subtype[Int]
    type HECAcknowledgmentTimeoutInSeconds =
      zio.aws.firehose.model.primitives.HECAcknowledgmentTimeoutInSeconds.Type
    object HECEndpoint extends Subtype[String]
    type HECEndpoint = zio.aws.firehose.model.primitives.HECEndpoint.Type
    object HECToken extends Subtype[String]
    type HECToken = zio.aws.firehose.model.primitives.HECToken.Type
    object HttpEndpointAccessKey extends Subtype[String]
    type HttpEndpointAccessKey =
      zio.aws.firehose.model.primitives.HttpEndpointAccessKey.Type
    object HttpEndpointAttributeName extends Subtype[String]
    type HttpEndpointAttributeName =
      zio.aws.firehose.model.primitives.HttpEndpointAttributeName.Type
    object HttpEndpointAttributeValue extends Subtype[String]
    type HttpEndpointAttributeValue =
      zio.aws.firehose.model.primitives.HttpEndpointAttributeValue.Type
    object HttpEndpointBufferingIntervalInSeconds extends Subtype[Int]
    type HttpEndpointBufferingIntervalInSeconds =
      zio.aws.firehose.model.primitives.HttpEndpointBufferingIntervalInSeconds.Type
    object HttpEndpointBufferingSizeInMBs extends Subtype[Int]
    type HttpEndpointBufferingSizeInMBs =
      zio.aws.firehose.model.primitives.HttpEndpointBufferingSizeInMBs.Type
    object HttpEndpointName extends Subtype[String]
    type HttpEndpointName =
      zio.aws.firehose.model.primitives.HttpEndpointName.Type
    object HttpEndpointRetryDurationInSeconds extends Subtype[Int]
    type HttpEndpointRetryDurationInSeconds =
      zio.aws.firehose.model.primitives.HttpEndpointRetryDurationInSeconds.Type
    object HttpEndpointUrl extends Subtype[String]
    type HttpEndpointUrl =
      zio.aws.firehose.model.primitives.HttpEndpointUrl.Type
    object IntervalInSeconds extends Subtype[Int]
    type IntervalInSeconds =
      zio.aws.firehose.model.primitives.IntervalInSeconds.Type
    object KinesisStreamARN extends Subtype[String]
    type KinesisStreamARN =
      zio.aws.firehose.model.primitives.KinesisStreamARN.Type
    object ListDeliveryStreamsInputLimit extends Subtype[Int]
    type ListDeliveryStreamsInputLimit =
      zio.aws.firehose.model.primitives.ListDeliveryStreamsInputLimit.Type
    object ListTagsForDeliveryStreamInputLimit extends Subtype[Int]
    type ListTagsForDeliveryStreamInputLimit =
      zio.aws.firehose.model.primitives.ListTagsForDeliveryStreamInputLimit.Type
    object LogGroupName extends Subtype[String]
    type LogGroupName = zio.aws.firehose.model.primitives.LogGroupName.Type
    object LogStreamName extends Subtype[String]
    type LogStreamName = zio.aws.firehose.model.primitives.LogStreamName.Type
    object NonEmptyString extends Subtype[String]
    type NonEmptyString = zio.aws.firehose.model.primitives.NonEmptyString.Type
    object NonEmptyStringWithoutWhitespace extends Subtype[String]
    type NonEmptyStringWithoutWhitespace =
      zio.aws.firehose.model.primitives.NonEmptyStringWithoutWhitespace.Type
    object NonNegativeIntegerObject extends Subtype[Int]
    type NonNegativeIntegerObject =
      zio.aws.firehose.model.primitives.NonNegativeIntegerObject.Type
    object OrcRowIndexStride extends Subtype[Int]
    type OrcRowIndexStride =
      zio.aws.firehose.model.primitives.OrcRowIndexStride.Type
    object OrcStripeSizeBytes extends Subtype[Int]
    type OrcStripeSizeBytes =
      zio.aws.firehose.model.primitives.OrcStripeSizeBytes.Type
    object ParquetPageSizeBytes extends Subtype[Int]
    type ParquetPageSizeBytes =
      zio.aws.firehose.model.primitives.ParquetPageSizeBytes.Type
    object Password extends Subtype[String]
    type Password = zio.aws.firehose.model.primitives.Password.Type
    object Prefix extends Subtype[String]
    type Prefix = zio.aws.firehose.model.primitives.Prefix.Type
    object ProcessorParameterValue extends Subtype[String]
    type ProcessorParameterValue =
      zio.aws.firehose.model.primitives.ProcessorParameterValue.Type
    object Proportion extends Subtype[Double]
    type Proportion = zio.aws.firehose.model.primitives.Proportion.Type
    object PutResponseRecordId extends Subtype[String]
    type PutResponseRecordId =
      zio.aws.firehose.model.primitives.PutResponseRecordId.Type
    object RedshiftRetryDurationInSeconds extends Subtype[Int]
    type RedshiftRetryDurationInSeconds =
      zio.aws.firehose.model.primitives.RedshiftRetryDurationInSeconds.Type
    object RetryDurationInSeconds extends Subtype[Int]
    type RetryDurationInSeconds =
      zio.aws.firehose.model.primitives.RetryDurationInSeconds.Type
    object RoleARN extends Subtype[String]
    type RoleARN = zio.aws.firehose.model.primitives.RoleARN.Type
    object SizeInMBs extends Subtype[Int]
    type SizeInMBs = zio.aws.firehose.model.primitives.SizeInMBs.Type
    object SplunkRetryDurationInSeconds extends Subtype[Int]
    type SplunkRetryDurationInSeconds =
      zio.aws.firehose.model.primitives.SplunkRetryDurationInSeconds.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.firehose.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.firehose.model.primitives.TagValue.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.firehose.model.primitives.Timestamp.Type
    object Username extends Subtype[String]
    type Username = zio.aws.firehose.model.primitives.Username.Type
  }
  type ColumnToJsonKeyMappings =
    Map[NonEmptyStringWithoutWhitespace, NonEmptyString]
  type DeliveryStreamNameList = List[DeliveryStreamName]
  type DestinationDescriptionList =
    List[zio.aws.firehose.model.DestinationDescription]
  type HttpEndpointCommonAttributesList =
    List[zio.aws.firehose.model.HttpEndpointCommonAttribute]
  type ListOfNonEmptyStrings = List[NonEmptyString]
  type ListOfNonEmptyStringsWithoutWhitespace =
    List[NonEmptyStringWithoutWhitespace]
  type ListTagsForDeliveryStreamOutputTagList = List[zio.aws.firehose.model.Tag]
  type ProcessorList = List[zio.aws.firehose.model.Processor]
  type ProcessorParameterList = List[zio.aws.firehose.model.ProcessorParameter]
  type PutRecordBatchRequestEntryList = List[zio.aws.firehose.model.Record]
  type PutRecordBatchResponseEntryList =
    List[zio.aws.firehose.model.PutRecordBatchResponseEntry]
  type SecurityGroupIdList = List[NonEmptyStringWithoutWhitespace]
  type SubnetIdList = List[NonEmptyStringWithoutWhitespace]
  type TagDeliveryStreamInputTagList = List[zio.aws.firehose.model.Tag]
  type TagKeyList = List[TagKey]
}
