package zio.aws.firehose.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.firehose.model.primitives.{
  AmazonOpenSearchServerlessBufferingSizeInMBs,
  AmazonOpenSearchServerlessBufferingIntervalInSeconds
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class AmazonOpenSearchServerlessBufferingHints(
    intervalInSeconds: Optional[
      AmazonOpenSearchServerlessBufferingIntervalInSeconds
    ] = Optional.Absent,
    sizeInMBs: Optional[AmazonOpenSearchServerlessBufferingSizeInMBs] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.AmazonOpenSearchServerlessBufferingHints = {
    import AmazonOpenSearchServerlessBufferingHints.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.AmazonOpenSearchServerlessBufferingHints
      .builder()
      .optionallyWith(
        intervalInSeconds.map(value =>
          AmazonOpenSearchServerlessBufferingIntervalInSeconds.unwrap(
            value
          ): Integer
        )
      )(_.intervalInSeconds)
      .optionallyWith(
        sizeInMBs.map(value =>
          AmazonOpenSearchServerlessBufferingSizeInMBs.unwrap(value): Integer
        )
      )(_.sizeInMBs)
      .build()
  }
  def asReadOnly
      : zio.aws.firehose.model.AmazonOpenSearchServerlessBufferingHints.ReadOnly =
    zio.aws.firehose.model.AmazonOpenSearchServerlessBufferingHints
      .wrap(buildAwsValue())
}
object AmazonOpenSearchServerlessBufferingHints {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.AmazonOpenSearchServerlessBufferingHints
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.firehose.model.AmazonOpenSearchServerlessBufferingHints =
      zio.aws.firehose.model.AmazonOpenSearchServerlessBufferingHints(
        intervalInSeconds.map(value => value),
        sizeInMBs.map(value => value)
      )
    def intervalInSeconds
        : Optional[AmazonOpenSearchServerlessBufferingIntervalInSeconds]
    def sizeInMBs: Optional[AmazonOpenSearchServerlessBufferingSizeInMBs]
    def getIntervalInSeconds: ZIO[
      Any,
      AwsError,
      AmazonOpenSearchServerlessBufferingIntervalInSeconds
    ] = AwsError.unwrapOptionField("intervalInSeconds", intervalInSeconds)
    def getSizeInMBs
        : ZIO[Any, AwsError, AmazonOpenSearchServerlessBufferingSizeInMBs] =
      AwsError.unwrapOptionField("sizeInMBs", sizeInMBs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.AmazonOpenSearchServerlessBufferingHints
  ) extends zio.aws.firehose.model.AmazonOpenSearchServerlessBufferingHints.ReadOnly {
    override val intervalInSeconds
        : Optional[AmazonOpenSearchServerlessBufferingIntervalInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.intervalInSeconds())
        .map(value =>
          zio.aws.firehose.model.primitives
            .AmazonOpenSearchServerlessBufferingIntervalInSeconds(value)
        )
    override val sizeInMBs
        : Optional[AmazonOpenSearchServerlessBufferingSizeInMBs] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sizeInMBs())
        .map(value =>
          zio.aws.firehose.model.primitives
            .AmazonOpenSearchServerlessBufferingSizeInMBs(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.AmazonOpenSearchServerlessBufferingHints
  ): zio.aws.firehose.model.AmazonOpenSearchServerlessBufferingHints.ReadOnly =
    new Wrapper(impl)
}
