package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.{
  AmazonopensearchserviceTypeName,
  AmazonopensearchserviceClusterEndpoint,
  AmazonopensearchserviceDomainARN,
  AmazonopensearchserviceIndexName,
  RoleARN
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AmazonopensearchserviceDestinationDescription(
    roleARN: Optional[RoleARN] = Optional.Absent,
    domainARN: Optional[AmazonopensearchserviceDomainARN] = Optional.Absent,
    clusterEndpoint: Optional[AmazonopensearchserviceClusterEndpoint] =
      Optional.Absent,
    indexName: Optional[AmazonopensearchserviceIndexName] = Optional.Absent,
    typeName: Optional[AmazonopensearchserviceTypeName] = Optional.Absent,
    indexRotationPeriod: Optional[
      zio.aws.firehose.model.AmazonopensearchserviceIndexRotationPeriod
    ] = Optional.Absent,
    bufferingHints: Optional[
      zio.aws.firehose.model.AmazonopensearchserviceBufferingHints
    ] = Optional.Absent,
    retryOptions: Optional[
      zio.aws.firehose.model.AmazonopensearchserviceRetryOptions
    ] = Optional.Absent,
    s3BackupMode: Optional[
      zio.aws.firehose.model.AmazonopensearchserviceS3BackupMode
    ] = Optional.Absent,
    s3DestinationDescription: Optional[
      zio.aws.firehose.model.S3DestinationDescription
    ] = Optional.Absent,
    processingConfiguration: Optional[
      zio.aws.firehose.model.ProcessingConfiguration
    ] = Optional.Absent,
    cloudWatchLoggingOptions: Optional[
      zio.aws.firehose.model.CloudWatchLoggingOptions
    ] = Optional.Absent,
    vpcConfigurationDescription: Optional[
      zio.aws.firehose.model.VpcConfigurationDescription
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.AmazonopensearchserviceDestinationDescription = {
    import AmazonopensearchserviceDestinationDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.AmazonopensearchserviceDestinationDescription
      .builder()
      .optionallyWith(
        roleARN.map(value => RoleARN.unwrap(value): java.lang.String)
      )(_.roleARN)
      .optionallyWith(
        domainARN.map(value =>
          AmazonopensearchserviceDomainARN.unwrap(value): java.lang.String
        )
      )(_.domainARN)
      .optionallyWith(
        clusterEndpoint.map(value =>
          AmazonopensearchserviceClusterEndpoint.unwrap(value): java.lang.String
        )
      )(_.clusterEndpoint)
      .optionallyWith(
        indexName.map(value =>
          AmazonopensearchserviceIndexName.unwrap(value): java.lang.String
        )
      )(_.indexName)
      .optionallyWith(
        typeName.map(value =>
          AmazonopensearchserviceTypeName.unwrap(value): java.lang.String
        )
      )(_.typeName)
      .optionallyWith(indexRotationPeriod.map(value => value.unwrap))(
        _.indexRotationPeriod
      )
      .optionallyWith(bufferingHints.map(value => value.buildAwsValue()))(
        _.bufferingHints
      )
      .optionallyWith(retryOptions.map(value => value.buildAwsValue()))(
        _.retryOptions
      )
      .optionallyWith(s3BackupMode.map(value => value.unwrap))(_.s3BackupMode)
      .optionallyWith(
        s3DestinationDescription.map(value => value.buildAwsValue())
      )(_.s3DestinationDescription)
      .optionallyWith(
        processingConfiguration.map(value => value.buildAwsValue())
      )(_.processingConfiguration)
      .optionallyWith(
        cloudWatchLoggingOptions.map(value => value.buildAwsValue())
      )(_.cloudWatchLoggingOptions)
      .optionallyWith(
        vpcConfigurationDescription.map(value => value.buildAwsValue())
      )(_.vpcConfigurationDescription)
      .build()
  }
  def asReadOnly
      : zio.aws.firehose.model.AmazonopensearchserviceDestinationDescription.ReadOnly =
    zio.aws.firehose.model.AmazonopensearchserviceDestinationDescription
      .wrap(buildAwsValue())
}
object AmazonopensearchserviceDestinationDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.AmazonopensearchserviceDestinationDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.firehose.model.AmazonopensearchserviceDestinationDescription =
      zio.aws.firehose.model.AmazonopensearchserviceDestinationDescription(
        roleARN.map(value => value),
        domainARN.map(value => value),
        clusterEndpoint.map(value => value),
        indexName.map(value => value),
        typeName.map(value => value),
        indexRotationPeriod.map(value => value),
        bufferingHints.map(value => value.asEditable),
        retryOptions.map(value => value.asEditable),
        s3BackupMode.map(value => value),
        s3DestinationDescription.map(value => value.asEditable),
        processingConfiguration.map(value => value.asEditable),
        cloudWatchLoggingOptions.map(value => value.asEditable),
        vpcConfigurationDescription.map(value => value.asEditable)
      )
    def roleARN: Optional[RoleARN]
    def domainARN: Optional[AmazonopensearchserviceDomainARN]
    def clusterEndpoint: Optional[AmazonopensearchserviceClusterEndpoint]
    def indexName: Optional[AmazonopensearchserviceIndexName]
    def typeName: Optional[AmazonopensearchserviceTypeName]
    def indexRotationPeriod: Optional[
      zio.aws.firehose.model.AmazonopensearchserviceIndexRotationPeriod
    ]
    def bufferingHints: Optional[
      zio.aws.firehose.model.AmazonopensearchserviceBufferingHints.ReadOnly
    ]
    def retryOptions: Optional[
      zio.aws.firehose.model.AmazonopensearchserviceRetryOptions.ReadOnly
    ]
    def s3BackupMode
        : Optional[zio.aws.firehose.model.AmazonopensearchserviceS3BackupMode]
    def s3DestinationDescription
        : Optional[zio.aws.firehose.model.S3DestinationDescription.ReadOnly]
    def processingConfiguration
        : Optional[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly]
    def cloudWatchLoggingOptions
        : Optional[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly]
    def vpcConfigurationDescription
        : Optional[zio.aws.firehose.model.VpcConfigurationDescription.ReadOnly]
    def getRoleARN: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("roleARN", roleARN)
    def getDomainARN: ZIO[Any, AwsError, AmazonopensearchserviceDomainARN] =
      AwsError.unwrapOptionField("domainARN", domainARN)
    def getClusterEndpoint
        : ZIO[Any, AwsError, AmazonopensearchserviceClusterEndpoint] =
      AwsError.unwrapOptionField("clusterEndpoint", clusterEndpoint)
    def getIndexName: ZIO[Any, AwsError, AmazonopensearchserviceIndexName] =
      AwsError.unwrapOptionField("indexName", indexName)
    def getTypeName: ZIO[Any, AwsError, AmazonopensearchserviceTypeName] =
      AwsError.unwrapOptionField("typeName", typeName)
    def getIndexRotationPeriod: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.AmazonopensearchserviceIndexRotationPeriod
    ] = AwsError.unwrapOptionField("indexRotationPeriod", indexRotationPeriod)
    def getBufferingHints: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.AmazonopensearchserviceBufferingHints.ReadOnly
    ] = AwsError.unwrapOptionField("bufferingHints", bufferingHints)
    def getRetryOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.AmazonopensearchserviceRetryOptions.ReadOnly
    ] = AwsError.unwrapOptionField("retryOptions", retryOptions)
    def getS3BackupMode: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.AmazonopensearchserviceS3BackupMode
    ] = AwsError.unwrapOptionField("s3BackupMode", s3BackupMode)
    def getS3DestinationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.S3DestinationDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "s3DestinationDescription",
      s3DestinationDescription
    )
    def getProcessingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.ProcessingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "processingConfiguration",
      processingConfiguration
    )
    def getCloudWatchLoggingOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudWatchLoggingOptions",
      cloudWatchLoggingOptions
    )
    def getVpcConfigurationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.VpcConfigurationDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "vpcConfigurationDescription",
      vpcConfigurationDescription
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.AmazonopensearchserviceDestinationDescription
  ) extends zio.aws.firehose.model.AmazonopensearchserviceDestinationDescription.ReadOnly {
    override val roleARN: Optional[RoleARN] = zio.aws.core.internal
      .optionalFromNullable(impl.roleARN())
      .map(value => zio.aws.firehose.model.primitives.RoleARN(value))
    override val domainARN: Optional[AmazonopensearchserviceDomainARN] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainARN())
        .map(value =>
          zio.aws.firehose.model.primitives
            .AmazonopensearchserviceDomainARN(value)
        )
    override val clusterEndpoint
        : Optional[AmazonopensearchserviceClusterEndpoint] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterEndpoint())
        .map(value =>
          zio.aws.firehose.model.primitives
            .AmazonopensearchserviceClusterEndpoint(value)
        )
    override val indexName: Optional[AmazonopensearchserviceIndexName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.indexName())
        .map(value =>
          zio.aws.firehose.model.primitives
            .AmazonopensearchserviceIndexName(value)
        )
    override val typeName: Optional[AmazonopensearchserviceTypeName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.typeName())
        .map(value =>
          zio.aws.firehose.model.primitives
            .AmazonopensearchserviceTypeName(value)
        )
    override val indexRotationPeriod: Optional[
      zio.aws.firehose.model.AmazonopensearchserviceIndexRotationPeriod
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.indexRotationPeriod())
      .map(value =>
        zio.aws.firehose.model.AmazonopensearchserviceIndexRotationPeriod
          .wrap(value)
      )
    override val bufferingHints: Optional[
      zio.aws.firehose.model.AmazonopensearchserviceBufferingHints.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.bufferingHints())
      .map(value =>
        zio.aws.firehose.model.AmazonopensearchserviceBufferingHints.wrap(value)
      )
    override val retryOptions: Optional[
      zio.aws.firehose.model.AmazonopensearchserviceRetryOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.retryOptions())
      .map(value =>
        zio.aws.firehose.model.AmazonopensearchserviceRetryOptions.wrap(value)
      )
    override val s3BackupMode
        : Optional[zio.aws.firehose.model.AmazonopensearchserviceS3BackupMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3BackupMode())
        .map(value =>
          zio.aws.firehose.model.AmazonopensearchserviceS3BackupMode.wrap(value)
        )
    override val s3DestinationDescription
        : Optional[zio.aws.firehose.model.S3DestinationDescription.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3DestinationDescription())
        .map(value =>
          zio.aws.firehose.model.S3DestinationDescription.wrap(value)
        )
    override val processingConfiguration
        : Optional[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processingConfiguration())
        .map(value =>
          zio.aws.firehose.model.ProcessingConfiguration.wrap(value)
        )
    override val cloudWatchLoggingOptions
        : Optional[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchLoggingOptions())
        .map(value =>
          zio.aws.firehose.model.CloudWatchLoggingOptions.wrap(value)
        )
    override val vpcConfigurationDescription: Optional[
      zio.aws.firehose.model.VpcConfigurationDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcConfigurationDescription())
      .map(value =>
        zio.aws.firehose.model.VpcConfigurationDescription.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.AmazonopensearchserviceDestinationDescription
  ): zio.aws.firehose.model.AmazonopensearchserviceDestinationDescription.ReadOnly =
    new Wrapper(impl)
}
