package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.{
  LogStreamName,
  LogGroupName,
  BooleanObject
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CloudWatchLoggingOptions(
    enabled: Optional[BooleanObject] = Optional.Absent,
    logGroupName: Optional[LogGroupName] = Optional.Absent,
    logStreamName: Optional[LogStreamName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.CloudWatchLoggingOptions = {
    import CloudWatchLoggingOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.CloudWatchLoggingOptions
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(
        logGroupName.map(value => LogGroupName.unwrap(value): java.lang.String)
      )(_.logGroupName)
      .optionallyWith(
        logStreamName.map(value =>
          LogStreamName.unwrap(value): java.lang.String
        )
      )(_.logStreamName)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly =
    zio.aws.firehose.model.CloudWatchLoggingOptions.wrap(buildAwsValue())
}
object CloudWatchLoggingOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.CloudWatchLoggingOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.CloudWatchLoggingOptions =
      zio.aws.firehose.model.CloudWatchLoggingOptions(
        enabled.map(value => value),
        logGroupName.map(value => value),
        logStreamName.map(value => value)
      )
    def enabled: Optional[BooleanObject]
    def logGroupName: Optional[LogGroupName]
    def logStreamName: Optional[LogStreamName]
    def getEnabled: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getLogGroupName: ZIO[Any, AwsError, LogGroupName] =
      AwsError.unwrapOptionField("logGroupName", logGroupName)
    def getLogStreamName: ZIO[Any, AwsError, LogStreamName] =
      AwsError.unwrapOptionField("logStreamName", logStreamName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.CloudWatchLoggingOptions
  ) extends zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly {
    override val enabled: Optional[BooleanObject] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: BooleanObject)
    override val logGroupName: Optional[LogGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.logGroupName())
      .map(value => zio.aws.firehose.model.primitives.LogGroupName(value))
    override val logStreamName: Optional[LogStreamName] = zio.aws.core.internal
      .optionalFromNullable(impl.logStreamName())
      .map(value => zio.aws.firehose.model.primitives.LogStreamName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.CloudWatchLoggingOptions
  ): zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly = new Wrapper(
    impl
  )
}
