package zio.aws.firehose.model
import scala.jdk.CollectionConverters.*
sealed trait CompressionFormat {
  def unwrap: software.amazon.awssdk.services.firehose.model.CompressionFormat
}
object CompressionFormat {
  def wrap(
      value: software.amazon.awssdk.services.firehose.model.CompressionFormat
  ): zio.aws.firehose.model.CompressionFormat = value match {
    case software.amazon.awssdk.services.firehose.model.CompressionFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.firehose.model.CompressionFormat.UNCOMPRESSED =>
      val r = UNCOMPRESSED
      r
    case software.amazon.awssdk.services.firehose.model.CompressionFormat.GZIP =>
      val r = GZIP
      r
    case software.amazon.awssdk.services.firehose.model.CompressionFormat.ZIP =>
      val r = ZIP
      r
    case software.amazon.awssdk.services.firehose.model.CompressionFormat.SNAPPY =>
      val r = Snappy
      r
    case software.amazon.awssdk.services.firehose.model.CompressionFormat.HADOOP_SNAPPY =>
      val r = HADOOP_SNAPPY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.firehose.model.CompressionFormat {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.CompressionFormat =
      software.amazon.awssdk.services.firehose.model.CompressionFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object UNCOMPRESSED extends zio.aws.firehose.model.CompressionFormat {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.CompressionFormat =
      software.amazon.awssdk.services.firehose.model.CompressionFormat.UNCOMPRESSED
  }
  case object GZIP extends zio.aws.firehose.model.CompressionFormat {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.CompressionFormat =
      software.amazon.awssdk.services.firehose.model.CompressionFormat.GZIP
  }
  case object ZIP extends zio.aws.firehose.model.CompressionFormat {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.CompressionFormat =
      software.amazon.awssdk.services.firehose.model.CompressionFormat.ZIP
  }
  case object Snappy extends zio.aws.firehose.model.CompressionFormat {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.CompressionFormat =
      software.amazon.awssdk.services.firehose.model.CompressionFormat.SNAPPY
  }
  case object HADOOP_SNAPPY extends zio.aws.firehose.model.CompressionFormat {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.CompressionFormat =
      software.amazon.awssdk.services.firehose.model.CompressionFormat.HADOOP_SNAPPY
  }
}
