package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.DestinationId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DestinationDescription(
    destinationId: DestinationId,
    s3DestinationDescription: Optional[
      zio.aws.firehose.model.S3DestinationDescription
    ] = Optional.Absent,
    extendedS3DestinationDescription: Optional[
      zio.aws.firehose.model.ExtendedS3DestinationDescription
    ] = Optional.Absent,
    redshiftDestinationDescription: Optional[
      zio.aws.firehose.model.RedshiftDestinationDescription
    ] = Optional.Absent,
    elasticsearchDestinationDescription: Optional[
      zio.aws.firehose.model.ElasticsearchDestinationDescription
    ] = Optional.Absent,
    amazonopensearchserviceDestinationDescription: Optional[
      zio.aws.firehose.model.AmazonopensearchserviceDestinationDescription
    ] = Optional.Absent,
    splunkDestinationDescription: Optional[
      zio.aws.firehose.model.SplunkDestinationDescription
    ] = Optional.Absent,
    httpEndpointDestinationDescription: Optional[
      zio.aws.firehose.model.HttpEndpointDestinationDescription
    ] = Optional.Absent,
    amazonOpenSearchServerlessDestinationDescription: Optional[
      zio.aws.firehose.model.AmazonOpenSearchServerlessDestinationDescription
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.DestinationDescription = {
    import DestinationDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.DestinationDescription
      .builder()
      .destinationId(DestinationId.unwrap(destinationId): java.lang.String)
      .optionallyWith(
        s3DestinationDescription.map(value => value.buildAwsValue())
      )(_.s3DestinationDescription)
      .optionallyWith(
        extendedS3DestinationDescription.map(value => value.buildAwsValue())
      )(_.extendedS3DestinationDescription)
      .optionallyWith(
        redshiftDestinationDescription.map(value => value.buildAwsValue())
      )(_.redshiftDestinationDescription)
      .optionallyWith(
        elasticsearchDestinationDescription.map(value => value.buildAwsValue())
      )(_.elasticsearchDestinationDescription)
      .optionallyWith(
        amazonopensearchserviceDestinationDescription.map(value =>
          value.buildAwsValue()
        )
      )(_.amazonopensearchserviceDestinationDescription)
      .optionallyWith(
        splunkDestinationDescription.map(value => value.buildAwsValue())
      )(_.splunkDestinationDescription)
      .optionallyWith(
        httpEndpointDestinationDescription.map(value => value.buildAwsValue())
      )(_.httpEndpointDestinationDescription)
      .optionallyWith(
        amazonOpenSearchServerlessDestinationDescription.map(value =>
          value.buildAwsValue()
        )
      )(_.amazonOpenSearchServerlessDestinationDescription)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.DestinationDescription.ReadOnly =
    zio.aws.firehose.model.DestinationDescription.wrap(buildAwsValue())
}
object DestinationDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.DestinationDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.DestinationDescription =
      zio.aws.firehose.model.DestinationDescription(
        destinationId,
        s3DestinationDescription.map(value => value.asEditable),
        extendedS3DestinationDescription.map(value => value.asEditable),
        redshiftDestinationDescription.map(value => value.asEditable),
        elasticsearchDestinationDescription.map(value => value.asEditable),
        amazonopensearchserviceDestinationDescription.map(value =>
          value.asEditable
        ),
        splunkDestinationDescription.map(value => value.asEditable),
        httpEndpointDestinationDescription.map(value => value.asEditable),
        amazonOpenSearchServerlessDestinationDescription.map(value =>
          value.asEditable
        )
      )
    def destinationId: DestinationId
    def s3DestinationDescription
        : Optional[zio.aws.firehose.model.S3DestinationDescription.ReadOnly]
    def extendedS3DestinationDescription: Optional[
      zio.aws.firehose.model.ExtendedS3DestinationDescription.ReadOnly
    ]
    def redshiftDestinationDescription: Optional[
      zio.aws.firehose.model.RedshiftDestinationDescription.ReadOnly
    ]
    def elasticsearchDestinationDescription: Optional[
      zio.aws.firehose.model.ElasticsearchDestinationDescription.ReadOnly
    ]
    def amazonopensearchserviceDestinationDescription: Optional[
      zio.aws.firehose.model.AmazonopensearchserviceDestinationDescription.ReadOnly
    ]
    def splunkDestinationDescription
        : Optional[zio.aws.firehose.model.SplunkDestinationDescription.ReadOnly]
    def httpEndpointDestinationDescription: Optional[
      zio.aws.firehose.model.HttpEndpointDestinationDescription.ReadOnly
    ]
    def amazonOpenSearchServerlessDestinationDescription: Optional[
      zio.aws.firehose.model.AmazonOpenSearchServerlessDestinationDescription.ReadOnly
    ]
    def getDestinationId: ZIO[Any, Nothing, DestinationId] =
      ZIO.succeed(destinationId)
    def getS3DestinationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.S3DestinationDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "s3DestinationDescription",
      s3DestinationDescription
    )
    def getExtendedS3DestinationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.ExtendedS3DestinationDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "extendedS3DestinationDescription",
      extendedS3DestinationDescription
    )
    def getRedshiftDestinationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.RedshiftDestinationDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "redshiftDestinationDescription",
      redshiftDestinationDescription
    )
    def getElasticsearchDestinationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.ElasticsearchDestinationDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "elasticsearchDestinationDescription",
      elasticsearchDestinationDescription
    )
    def getAmazonopensearchserviceDestinationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.AmazonopensearchserviceDestinationDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "amazonopensearchserviceDestinationDescription",
      amazonopensearchserviceDestinationDescription
    )
    def getSplunkDestinationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.SplunkDestinationDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "splunkDestinationDescription",
      splunkDestinationDescription
    )
    def getHttpEndpointDestinationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.HttpEndpointDestinationDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "httpEndpointDestinationDescription",
      httpEndpointDestinationDescription
    )
    def getAmazonOpenSearchServerlessDestinationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.AmazonOpenSearchServerlessDestinationDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "amazonOpenSearchServerlessDestinationDescription",
      amazonOpenSearchServerlessDestinationDescription
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.DestinationDescription
  ) extends zio.aws.firehose.model.DestinationDescription.ReadOnly {
    override val destinationId: DestinationId =
      zio.aws.firehose.model.primitives.DestinationId(impl.destinationId())
    override val s3DestinationDescription
        : Optional[zio.aws.firehose.model.S3DestinationDescription.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3DestinationDescription())
        .map(value =>
          zio.aws.firehose.model.S3DestinationDescription.wrap(value)
        )
    override val extendedS3DestinationDescription: Optional[
      zio.aws.firehose.model.ExtendedS3DestinationDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.extendedS3DestinationDescription())
      .map(value =>
        zio.aws.firehose.model.ExtendedS3DestinationDescription.wrap(value)
      )
    override val redshiftDestinationDescription: Optional[
      zio.aws.firehose.model.RedshiftDestinationDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.redshiftDestinationDescription())
      .map(value =>
        zio.aws.firehose.model.RedshiftDestinationDescription.wrap(value)
      )
    override val elasticsearchDestinationDescription: Optional[
      zio.aws.firehose.model.ElasticsearchDestinationDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.elasticsearchDestinationDescription())
      .map(value =>
        zio.aws.firehose.model.ElasticsearchDestinationDescription.wrap(value)
      )
    override val amazonopensearchserviceDestinationDescription: Optional[
      zio.aws.firehose.model.AmazonopensearchserviceDestinationDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.amazonopensearchserviceDestinationDescription()
      )
      .map(value =>
        zio.aws.firehose.model.AmazonopensearchserviceDestinationDescription
          .wrap(value)
      )
    override val splunkDestinationDescription: Optional[
      zio.aws.firehose.model.SplunkDestinationDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.splunkDestinationDescription())
      .map(value =>
        zio.aws.firehose.model.SplunkDestinationDescription.wrap(value)
      )
    override val httpEndpointDestinationDescription: Optional[
      zio.aws.firehose.model.HttpEndpointDestinationDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.httpEndpointDestinationDescription())
      .map(value =>
        zio.aws.firehose.model.HttpEndpointDestinationDescription.wrap(value)
      )
    override val amazonOpenSearchServerlessDestinationDescription: Optional[
      zio.aws.firehose.model.AmazonOpenSearchServerlessDestinationDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.amazonOpenSearchServerlessDestinationDescription()
      )
      .map(value =>
        zio.aws.firehose.model.AmazonOpenSearchServerlessDestinationDescription
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.DestinationDescription
  ): zio.aws.firehose.model.DestinationDescription.ReadOnly = new Wrapper(impl)
}
