package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.BooleanObject
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DynamicPartitioningConfiguration(
    retryOptions: Optional[zio.aws.firehose.model.RetryOptions] =
      Optional.Absent,
    enabled: Optional[BooleanObject] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.DynamicPartitioningConfiguration = {
    import DynamicPartitioningConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.DynamicPartitioningConfiguration
      .builder()
      .optionallyWith(retryOptions.map(value => value.buildAwsValue()))(
        _.retryOptions
      )
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly
      : zio.aws.firehose.model.DynamicPartitioningConfiguration.ReadOnly =
    zio.aws.firehose.model.DynamicPartitioningConfiguration
      .wrap(buildAwsValue())
}
object DynamicPartitioningConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.DynamicPartitioningConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.DynamicPartitioningConfiguration =
      zio.aws.firehose.model.DynamicPartitioningConfiguration(
        retryOptions.map(value => value.asEditable),
        enabled.map(value => value)
      )
    def retryOptions: Optional[zio.aws.firehose.model.RetryOptions.ReadOnly]
    def enabled: Optional[BooleanObject]
    def getRetryOptions
        : ZIO[Any, AwsError, zio.aws.firehose.model.RetryOptions.ReadOnly] =
      AwsError.unwrapOptionField("retryOptions", retryOptions)
    def getEnabled: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.DynamicPartitioningConfiguration
  ) extends zio.aws.firehose.model.DynamicPartitioningConfiguration.ReadOnly {
    override val retryOptions
        : Optional[zio.aws.firehose.model.RetryOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retryOptions())
        .map(value => zio.aws.firehose.model.RetryOptions.wrap(value))
    override val enabled: Optional[BooleanObject] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: BooleanObject)
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.DynamicPartitioningConfiguration
  ): zio.aws.firehose.model.DynamicPartitioningConfiguration.ReadOnly =
    new Wrapper(impl)
}
