package zio.aws.firehose.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.firehose.model.primitives.{
  ElasticsearchBufferingSizeInMBs,
  ElasticsearchBufferingIntervalInSeconds
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ElasticsearchBufferingHints(
    intervalInSeconds: Optional[ElasticsearchBufferingIntervalInSeconds] =
      Optional.Absent,
    sizeInMBs: Optional[ElasticsearchBufferingSizeInMBs] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.ElasticsearchBufferingHints = {
    import ElasticsearchBufferingHints.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.ElasticsearchBufferingHints
      .builder()
      .optionallyWith(
        intervalInSeconds.map(value =>
          ElasticsearchBufferingIntervalInSeconds.unwrap(value): Integer
        )
      )(_.intervalInSeconds)
      .optionallyWith(
        sizeInMBs.map(value =>
          ElasticsearchBufferingSizeInMBs.unwrap(value): Integer
        )
      )(_.sizeInMBs)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.ElasticsearchBufferingHints.ReadOnly =
    zio.aws.firehose.model.ElasticsearchBufferingHints.wrap(buildAwsValue())
}
object ElasticsearchBufferingHints {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.ElasticsearchBufferingHints
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.ElasticsearchBufferingHints =
      zio.aws.firehose.model.ElasticsearchBufferingHints(
        intervalInSeconds.map(value => value),
        sizeInMBs.map(value => value)
      )
    def intervalInSeconds: Optional[ElasticsearchBufferingIntervalInSeconds]
    def sizeInMBs: Optional[ElasticsearchBufferingSizeInMBs]
    def getIntervalInSeconds
        : ZIO[Any, AwsError, ElasticsearchBufferingIntervalInSeconds] =
      AwsError.unwrapOptionField("intervalInSeconds", intervalInSeconds)
    def getSizeInMBs: ZIO[Any, AwsError, ElasticsearchBufferingSizeInMBs] =
      AwsError.unwrapOptionField("sizeInMBs", sizeInMBs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.ElasticsearchBufferingHints
  ) extends zio.aws.firehose.model.ElasticsearchBufferingHints.ReadOnly {
    override val intervalInSeconds
        : Optional[ElasticsearchBufferingIntervalInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.intervalInSeconds())
        .map(value =>
          zio.aws.firehose.model.primitives
            .ElasticsearchBufferingIntervalInSeconds(value)
        )
    override val sizeInMBs: Optional[ElasticsearchBufferingSizeInMBs] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sizeInMBs())
        .map(value =>
          zio.aws.firehose.model.primitives
            .ElasticsearchBufferingSizeInMBs(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.ElasticsearchBufferingHints
  ): zio.aws.firehose.model.ElasticsearchBufferingHints.ReadOnly = new Wrapper(
    impl
  )
}
