package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.{
  ElasticsearchIndexName,
  ElasticsearchTypeName,
  ElasticsearchDomainARN,
  RoleARN,
  ElasticsearchClusterEndpoint
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ElasticsearchDestinationConfiguration(
    roleARN: RoleARN,
    domainARN: Optional[ElasticsearchDomainARN] = Optional.Absent,
    clusterEndpoint: Optional[ElasticsearchClusterEndpoint] = Optional.Absent,
    indexName: ElasticsearchIndexName,
    typeName: Optional[ElasticsearchTypeName] = Optional.Absent,
    indexRotationPeriod: Optional[
      zio.aws.firehose.model.ElasticsearchIndexRotationPeriod
    ] = Optional.Absent,
    bufferingHints: Optional[
      zio.aws.firehose.model.ElasticsearchBufferingHints
    ] = Optional.Absent,
    retryOptions: Optional[zio.aws.firehose.model.ElasticsearchRetryOptions] =
      Optional.Absent,
    s3BackupMode: Optional[zio.aws.firehose.model.ElasticsearchS3BackupMode] =
      Optional.Absent,
    s3Configuration: zio.aws.firehose.model.S3DestinationConfiguration,
    processingConfiguration: Optional[
      zio.aws.firehose.model.ProcessingConfiguration
    ] = Optional.Absent,
    cloudWatchLoggingOptions: Optional[
      zio.aws.firehose.model.CloudWatchLoggingOptions
    ] = Optional.Absent,
    vpcConfiguration: Optional[zio.aws.firehose.model.VpcConfiguration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.ElasticsearchDestinationConfiguration = {
    import ElasticsearchDestinationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.ElasticsearchDestinationConfiguration
      .builder()
      .roleARN(RoleARN.unwrap(roleARN): java.lang.String)
      .optionallyWith(
        domainARN.map(value =>
          ElasticsearchDomainARN.unwrap(value): java.lang.String
        )
      )(_.domainARN)
      .optionallyWith(
        clusterEndpoint.map(value =>
          ElasticsearchClusterEndpoint.unwrap(value): java.lang.String
        )
      )(_.clusterEndpoint)
      .indexName(ElasticsearchIndexName.unwrap(indexName): java.lang.String)
      .optionallyWith(
        typeName.map(value =>
          ElasticsearchTypeName.unwrap(value): java.lang.String
        )
      )(_.typeName)
      .optionallyWith(indexRotationPeriod.map(value => value.unwrap))(
        _.indexRotationPeriod
      )
      .optionallyWith(bufferingHints.map(value => value.buildAwsValue()))(
        _.bufferingHints
      )
      .optionallyWith(retryOptions.map(value => value.buildAwsValue()))(
        _.retryOptions
      )
      .optionallyWith(s3BackupMode.map(value => value.unwrap))(_.s3BackupMode)
      .s3Configuration(s3Configuration.buildAwsValue())
      .optionallyWith(
        processingConfiguration.map(value => value.buildAwsValue())
      )(_.processingConfiguration)
      .optionallyWith(
        cloudWatchLoggingOptions.map(value => value.buildAwsValue())
      )(_.cloudWatchLoggingOptions)
      .optionallyWith(vpcConfiguration.map(value => value.buildAwsValue()))(
        _.vpcConfiguration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.firehose.model.ElasticsearchDestinationConfiguration.ReadOnly =
    zio.aws.firehose.model.ElasticsearchDestinationConfiguration
      .wrap(buildAwsValue())
}
object ElasticsearchDestinationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.ElasticsearchDestinationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.firehose.model.ElasticsearchDestinationConfiguration =
      zio.aws.firehose.model.ElasticsearchDestinationConfiguration(
        roleARN,
        domainARN.map(value => value),
        clusterEndpoint.map(value => value),
        indexName,
        typeName.map(value => value),
        indexRotationPeriod.map(value => value),
        bufferingHints.map(value => value.asEditable),
        retryOptions.map(value => value.asEditable),
        s3BackupMode.map(value => value),
        s3Configuration.asEditable,
        processingConfiguration.map(value => value.asEditable),
        cloudWatchLoggingOptions.map(value => value.asEditable),
        vpcConfiguration.map(value => value.asEditable)
      )
    def roleARN: RoleARN
    def domainARN: Optional[ElasticsearchDomainARN]
    def clusterEndpoint: Optional[ElasticsearchClusterEndpoint]
    def indexName: ElasticsearchIndexName
    def typeName: Optional[ElasticsearchTypeName]
    def indexRotationPeriod
        : Optional[zio.aws.firehose.model.ElasticsearchIndexRotationPeriod]
    def bufferingHints
        : Optional[zio.aws.firehose.model.ElasticsearchBufferingHints.ReadOnly]
    def retryOptions
        : Optional[zio.aws.firehose.model.ElasticsearchRetryOptions.ReadOnly]
    def s3BackupMode: Optional[zio.aws.firehose.model.ElasticsearchS3BackupMode]
    def s3Configuration
        : zio.aws.firehose.model.S3DestinationConfiguration.ReadOnly
    def processingConfiguration
        : Optional[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly]
    def cloudWatchLoggingOptions
        : Optional[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly]
    def vpcConfiguration
        : Optional[zio.aws.firehose.model.VpcConfiguration.ReadOnly]
    def getRoleARN: ZIO[Any, Nothing, RoleARN] = ZIO.succeed(roleARN)
    def getDomainARN: ZIO[Any, AwsError, ElasticsearchDomainARN] =
      AwsError.unwrapOptionField("domainARN", domainARN)
    def getClusterEndpoint: ZIO[Any, AwsError, ElasticsearchClusterEndpoint] =
      AwsError.unwrapOptionField("clusterEndpoint", clusterEndpoint)
    def getIndexName: ZIO[Any, Nothing, ElasticsearchIndexName] =
      ZIO.succeed(indexName)
    def getTypeName: ZIO[Any, AwsError, ElasticsearchTypeName] =
      AwsError.unwrapOptionField("typeName", typeName)
    def getIndexRotationPeriod: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.ElasticsearchIndexRotationPeriod
    ] = AwsError.unwrapOptionField("indexRotationPeriod", indexRotationPeriod)
    def getBufferingHints: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.ElasticsearchBufferingHints.ReadOnly
    ] = AwsError.unwrapOptionField("bufferingHints", bufferingHints)
    def getRetryOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.ElasticsearchRetryOptions.ReadOnly
    ] = AwsError.unwrapOptionField("retryOptions", retryOptions)
    def getS3BackupMode
        : ZIO[Any, AwsError, zio.aws.firehose.model.ElasticsearchS3BackupMode] =
      AwsError.unwrapOptionField("s3BackupMode", s3BackupMode)
    def getS3Configuration: ZIO[
      Any,
      Nothing,
      zio.aws.firehose.model.S3DestinationConfiguration.ReadOnly
    ] = ZIO.succeed(s3Configuration)
    def getProcessingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.ProcessingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "processingConfiguration",
      processingConfiguration
    )
    def getCloudWatchLoggingOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudWatchLoggingOptions",
      cloudWatchLoggingOptions
    )
    def getVpcConfiguration
        : ZIO[Any, AwsError, zio.aws.firehose.model.VpcConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfiguration", vpcConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.ElasticsearchDestinationConfiguration
  ) extends zio.aws.firehose.model.ElasticsearchDestinationConfiguration.ReadOnly {
    override val roleARN: RoleARN =
      zio.aws.firehose.model.primitives.RoleARN(impl.roleARN())
    override val domainARN: Optional[ElasticsearchDomainARN] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainARN())
        .map(value =>
          zio.aws.firehose.model.primitives.ElasticsearchDomainARN(value)
        )
    override val clusterEndpoint: Optional[ElasticsearchClusterEndpoint] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterEndpoint())
        .map(value =>
          zio.aws.firehose.model.primitives.ElasticsearchClusterEndpoint(value)
        )
    override val indexName: ElasticsearchIndexName =
      zio.aws.firehose.model.primitives.ElasticsearchIndexName(impl.indexName())
    override val typeName: Optional[ElasticsearchTypeName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.typeName())
        .map(value =>
          zio.aws.firehose.model.primitives.ElasticsearchTypeName(value)
        )
    override val indexRotationPeriod
        : Optional[zio.aws.firehose.model.ElasticsearchIndexRotationPeriod] =
      zio.aws.core.internal
        .optionalFromNullable(impl.indexRotationPeriod())
        .map(value =>
          zio.aws.firehose.model.ElasticsearchIndexRotationPeriod.wrap(value)
        )
    override val bufferingHints: Optional[
      zio.aws.firehose.model.ElasticsearchBufferingHints.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.bufferingHints())
      .map(value =>
        zio.aws.firehose.model.ElasticsearchBufferingHints.wrap(value)
      )
    override val retryOptions
        : Optional[zio.aws.firehose.model.ElasticsearchRetryOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retryOptions())
        .map(value =>
          zio.aws.firehose.model.ElasticsearchRetryOptions.wrap(value)
        )
    override val s3BackupMode
        : Optional[zio.aws.firehose.model.ElasticsearchS3BackupMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3BackupMode())
        .map(value =>
          zio.aws.firehose.model.ElasticsearchS3BackupMode.wrap(value)
        )
    override val s3Configuration
        : zio.aws.firehose.model.S3DestinationConfiguration.ReadOnly =
      zio.aws.firehose.model.S3DestinationConfiguration
        .wrap(impl.s3Configuration())
    override val processingConfiguration
        : Optional[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processingConfiguration())
        .map(value =>
          zio.aws.firehose.model.ProcessingConfiguration.wrap(value)
        )
    override val cloudWatchLoggingOptions
        : Optional[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchLoggingOptions())
        .map(value =>
          zio.aws.firehose.model.CloudWatchLoggingOptions.wrap(value)
        )
    override val vpcConfiguration
        : Optional[zio.aws.firehose.model.VpcConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfiguration())
        .map(value => zio.aws.firehose.model.VpcConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.ElasticsearchDestinationConfiguration
  ): zio.aws.firehose.model.ElasticsearchDestinationConfiguration.ReadOnly =
    new Wrapper(impl)
}
