package zio.aws.firehose.model
import scala.jdk.CollectionConverters.*
sealed trait ElasticsearchIndexRotationPeriod {
  def unwrap: software.amazon.awssdk.services.firehose.model.ElasticsearchIndexRotationPeriod
}
object ElasticsearchIndexRotationPeriod {
  def wrap(
      value: software.amazon.awssdk.services.firehose.model.ElasticsearchIndexRotationPeriod
  ): zio.aws.firehose.model.ElasticsearchIndexRotationPeriod = value match {
    case software.amazon.awssdk.services.firehose.model.ElasticsearchIndexRotationPeriod.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.firehose.model.ElasticsearchIndexRotationPeriod.NO_ROTATION =>
      val r = NoRotation
      r
    case software.amazon.awssdk.services.firehose.model.ElasticsearchIndexRotationPeriod.ONE_HOUR =>
      val r = OneHour
      r
    case software.amazon.awssdk.services.firehose.model.ElasticsearchIndexRotationPeriod.ONE_DAY =>
      val r = OneDay
      r
    case software.amazon.awssdk.services.firehose.model.ElasticsearchIndexRotationPeriod.ONE_WEEK =>
      val r = OneWeek
      r
    case software.amazon.awssdk.services.firehose.model.ElasticsearchIndexRotationPeriod.ONE_MONTH =>
      val r = OneMonth
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.firehose.model.ElasticsearchIndexRotationPeriod {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.ElasticsearchIndexRotationPeriod =
      software.amazon.awssdk.services.firehose.model.ElasticsearchIndexRotationPeriod.UNKNOWN_TO_SDK_VERSION
  }
  case object NoRotation
      extends zio.aws.firehose.model.ElasticsearchIndexRotationPeriod {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.ElasticsearchIndexRotationPeriod =
      software.amazon.awssdk.services.firehose.model.ElasticsearchIndexRotationPeriod.NO_ROTATION
  }
  case object OneHour
      extends zio.aws.firehose.model.ElasticsearchIndexRotationPeriod {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.ElasticsearchIndexRotationPeriod =
      software.amazon.awssdk.services.firehose.model.ElasticsearchIndexRotationPeriod.ONE_HOUR
  }
  case object OneDay
      extends zio.aws.firehose.model.ElasticsearchIndexRotationPeriod {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.ElasticsearchIndexRotationPeriod =
      software.amazon.awssdk.services.firehose.model.ElasticsearchIndexRotationPeriod.ONE_DAY
  }
  case object OneWeek
      extends zio.aws.firehose.model.ElasticsearchIndexRotationPeriod {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.ElasticsearchIndexRotationPeriod =
      software.amazon.awssdk.services.firehose.model.ElasticsearchIndexRotationPeriod.ONE_WEEK
  }
  case object OneMonth
      extends zio.aws.firehose.model.ElasticsearchIndexRotationPeriod {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.ElasticsearchIndexRotationPeriod =
      software.amazon.awssdk.services.firehose.model.ElasticsearchIndexRotationPeriod.ONE_MONTH
  }
}
