package zio.aws.firehose.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.firehose.model.primitives.ElasticsearchRetryDurationInSeconds
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ElasticsearchRetryOptions(
    durationInSeconds: Optional[ElasticsearchRetryDurationInSeconds] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.ElasticsearchRetryOptions = {
    import ElasticsearchRetryOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.ElasticsearchRetryOptions
      .builder()
      .optionallyWith(
        durationInSeconds.map(value =>
          ElasticsearchRetryDurationInSeconds.unwrap(value): Integer
        )
      )(_.durationInSeconds)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.ElasticsearchRetryOptions.ReadOnly =
    zio.aws.firehose.model.ElasticsearchRetryOptions.wrap(buildAwsValue())
}
object ElasticsearchRetryOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.ElasticsearchRetryOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.ElasticsearchRetryOptions =
      zio.aws.firehose.model
        .ElasticsearchRetryOptions(durationInSeconds.map(value => value))
    def durationInSeconds: Optional[ElasticsearchRetryDurationInSeconds]
    def getDurationInSeconds
        : ZIO[Any, AwsError, ElasticsearchRetryDurationInSeconds] =
      AwsError.unwrapOptionField("durationInSeconds", durationInSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.ElasticsearchRetryOptions
  ) extends zio.aws.firehose.model.ElasticsearchRetryOptions.ReadOnly {
    override val durationInSeconds
        : Optional[ElasticsearchRetryDurationInSeconds] = zio.aws.core.internal
      .optionalFromNullable(impl.durationInSeconds())
      .map(value =>
        zio.aws.firehose.model.primitives
          .ElasticsearchRetryDurationInSeconds(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.ElasticsearchRetryOptions
  ): zio.aws.firehose.model.ElasticsearchRetryOptions.ReadOnly = new Wrapper(
    impl
  )
}
