package zio.aws.firehose.model
import scala.jdk.CollectionConverters.*
sealed trait HECEndpointType {
  def unwrap: software.amazon.awssdk.services.firehose.model.HECEndpointType
}
object HECEndpointType {
  def wrap(
      value: software.amazon.awssdk.services.firehose.model.HECEndpointType
  ): zio.aws.firehose.model.HECEndpointType = value match {
    case software.amazon.awssdk.services.firehose.model.HECEndpointType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.firehose.model.HECEndpointType.RAW =>
      val r = Raw
      r
    case software.amazon.awssdk.services.firehose.model.HECEndpointType.EVENT =>
      val r = Event
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.firehose.model.HECEndpointType {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.HECEndpointType =
      software.amazon.awssdk.services.firehose.model.HECEndpointType.UNKNOWN_TO_SDK_VERSION
  }
  case object Raw extends zio.aws.firehose.model.HECEndpointType {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.HECEndpointType =
      software.amazon.awssdk.services.firehose.model.HECEndpointType.RAW
  }
  case object Event extends zio.aws.firehose.model.HECEndpointType {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.HECEndpointType =
      software.amazon.awssdk.services.firehose.model.HECEndpointType.EVENT
  }
}
