package zio.aws.firehose.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.firehose.model.primitives.{
  HttpEndpointBufferingIntervalInSeconds,
  HttpEndpointBufferingSizeInMBs
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class HttpEndpointBufferingHints(
    sizeInMBs: Optional[HttpEndpointBufferingSizeInMBs] = Optional.Absent,
    intervalInSeconds: Optional[HttpEndpointBufferingIntervalInSeconds] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.HttpEndpointBufferingHints = {
    import HttpEndpointBufferingHints.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.HttpEndpointBufferingHints
      .builder()
      .optionallyWith(
        sizeInMBs.map(value =>
          HttpEndpointBufferingSizeInMBs.unwrap(value): Integer
        )
      )(_.sizeInMBs)
      .optionallyWith(
        intervalInSeconds.map(value =>
          HttpEndpointBufferingIntervalInSeconds.unwrap(value): Integer
        )
      )(_.intervalInSeconds)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.HttpEndpointBufferingHints.ReadOnly =
    zio.aws.firehose.model.HttpEndpointBufferingHints.wrap(buildAwsValue())
}
object HttpEndpointBufferingHints {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.HttpEndpointBufferingHints
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.HttpEndpointBufferingHints =
      zio.aws.firehose.model.HttpEndpointBufferingHints(
        sizeInMBs.map(value => value),
        intervalInSeconds.map(value => value)
      )
    def sizeInMBs: Optional[HttpEndpointBufferingSizeInMBs]
    def intervalInSeconds: Optional[HttpEndpointBufferingIntervalInSeconds]
    def getSizeInMBs: ZIO[Any, AwsError, HttpEndpointBufferingSizeInMBs] =
      AwsError.unwrapOptionField("sizeInMBs", sizeInMBs)
    def getIntervalInSeconds
        : ZIO[Any, AwsError, HttpEndpointBufferingIntervalInSeconds] =
      AwsError.unwrapOptionField("intervalInSeconds", intervalInSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.HttpEndpointBufferingHints
  ) extends zio.aws.firehose.model.HttpEndpointBufferingHints.ReadOnly {
    override val sizeInMBs: Optional[HttpEndpointBufferingSizeInMBs] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sizeInMBs())
        .map(value =>
          zio.aws.firehose.model.primitives
            .HttpEndpointBufferingSizeInMBs(value)
        )
    override val intervalInSeconds
        : Optional[HttpEndpointBufferingIntervalInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.intervalInSeconds())
        .map(value =>
          zio.aws.firehose.model.primitives
            .HttpEndpointBufferingIntervalInSeconds(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.HttpEndpointBufferingHints
  ): zio.aws.firehose.model.HttpEndpointBufferingHints.ReadOnly = new Wrapper(
    impl
  )
}
