package zio.aws.firehose.model
import scala.jdk.CollectionConverters.*
sealed trait HttpEndpointS3BackupMode {
  def unwrap
      : software.amazon.awssdk.services.firehose.model.HttpEndpointS3BackupMode
}
object HttpEndpointS3BackupMode {
  def wrap(
      value: software.amazon.awssdk.services.firehose.model.HttpEndpointS3BackupMode
  ): zio.aws.firehose.model.HttpEndpointS3BackupMode = value match {
    case software.amazon.awssdk.services.firehose.model.HttpEndpointS3BackupMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.firehose.model.HttpEndpointS3BackupMode.FAILED_DATA_ONLY =>
      val r = FailedDataOnly
      r
    case software.amazon.awssdk.services.firehose.model.HttpEndpointS3BackupMode.ALL_DATA =>
      val r = AllData
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.firehose.model.HttpEndpointS3BackupMode {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.HttpEndpointS3BackupMode =
      software.amazon.awssdk.services.firehose.model.HttpEndpointS3BackupMode.UNKNOWN_TO_SDK_VERSION
  }
  case object FailedDataOnly
      extends zio.aws.firehose.model.HttpEndpointS3BackupMode {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.HttpEndpointS3BackupMode =
      software.amazon.awssdk.services.firehose.model.HttpEndpointS3BackupMode.FAILED_DATA_ONLY
  }
  case object AllData extends zio.aws.firehose.model.HttpEndpointS3BackupMode {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.HttpEndpointS3BackupMode =
      software.amazon.awssdk.services.firehose.model.HttpEndpointS3BackupMode.ALL_DATA
  }
}
