package zio.aws.firehose.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.firehose.model.primitives.{
  DeliveryStartTimestamp,
  RoleARN,
  KinesisStreamARN
}
import scala.jdk.CollectionConverters.*
final case class KinesisStreamSourceDescription(
    kinesisStreamARN: Optional[KinesisStreamARN] = Optional.Absent,
    roleARN: Optional[RoleARN] = Optional.Absent,
    deliveryStartTimestamp: Optional[DeliveryStartTimestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.KinesisStreamSourceDescription = {
    import KinesisStreamSourceDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.KinesisStreamSourceDescription
      .builder()
      .optionallyWith(
        kinesisStreamARN.map(value =>
          KinesisStreamARN.unwrap(value): java.lang.String
        )
      )(_.kinesisStreamARN)
      .optionallyWith(
        roleARN.map(value => RoleARN.unwrap(value): java.lang.String)
      )(_.roleARN)
      .optionallyWith(
        deliveryStartTimestamp.map(value =>
          DeliveryStartTimestamp.unwrap(value): Instant
        )
      )(_.deliveryStartTimestamp)
      .build()
  }
  def asReadOnly
      : zio.aws.firehose.model.KinesisStreamSourceDescription.ReadOnly =
    zio.aws.firehose.model.KinesisStreamSourceDescription.wrap(buildAwsValue())
}
object KinesisStreamSourceDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.KinesisStreamSourceDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.KinesisStreamSourceDescription =
      zio.aws.firehose.model.KinesisStreamSourceDescription(
        kinesisStreamARN.map(value => value),
        roleARN.map(value => value),
        deliveryStartTimestamp.map(value => value)
      )
    def kinesisStreamARN: Optional[KinesisStreamARN]
    def roleARN: Optional[RoleARN]
    def deliveryStartTimestamp: Optional[DeliveryStartTimestamp]
    def getKinesisStreamARN: ZIO[Any, AwsError, KinesisStreamARN] =
      AwsError.unwrapOptionField("kinesisStreamARN", kinesisStreamARN)
    def getRoleARN: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("roleARN", roleARN)
    def getDeliveryStartTimestamp: ZIO[Any, AwsError, DeliveryStartTimestamp] =
      AwsError.unwrapOptionField(
        "deliveryStartTimestamp",
        deliveryStartTimestamp
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.KinesisStreamSourceDescription
  ) extends zio.aws.firehose.model.KinesisStreamSourceDescription.ReadOnly {
    override val kinesisStreamARN: Optional[KinesisStreamARN] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kinesisStreamARN())
        .map(value => zio.aws.firehose.model.primitives.KinesisStreamARN(value))
    override val roleARN: Optional[RoleARN] = zio.aws.core.internal
      .optionalFromNullable(impl.roleARN())
      .map(value => zio.aws.firehose.model.primitives.RoleARN(value))
    override val deliveryStartTimestamp: Optional[DeliveryStartTimestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deliveryStartTimestamp())
        .map(value =>
          zio.aws.firehose.model.primitives.DeliveryStartTimestamp(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.KinesisStreamSourceDescription
  ): zio.aws.firehose.model.KinesisStreamSourceDescription.ReadOnly =
    new Wrapper(impl)
}
